/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.util.Numbers;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Convention {
    private static final LazySet<Convention> AVAILABLES = new LazySet<Convention>(Convention.class);
    public static final Convention DEFAULT = new Convention();
    private static final String[] SEARCH_PATH = new String[]{"NCISOMetadata", "CFMetadata", null, "THREDDSMetadata"};
    private static final String[] RANGE_ATTRIBUTES = new String[]{"valid_range", "actual_range", "valid_min", "valid_max"};
    private static final String[] NODATA_ATTRIBUTES = new String[]{"_FillValue", "missing_value"};
    protected static final String LONGITUDE_OF_PRIME_MERIDIAN = "longitude_of_prime_meridian";
    protected static final String ELLIPSOID_NAME = "reference_ellipsoid_name";
    protected static final String PRIME_MERIDIAN_NAME = "prime_meridian_name";
    protected static final String GEODETIC_DATUM_NAME = "horizontal_datum_name";
    protected static final String GEOGRAPHIC_CRS_NAME = "geographic_crs_name";
    protected static final String PROJECTED_CRS_NAME = "projected_crs_name";
    protected static final String CONVERSION_NAME = "conversion_name";
    protected static final String TOWGS84 = "towgs84";

    protected Convention() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Convention find(Decoder decoder) {
        Convention c;
        Iterator<Convention> it;
        LazySet<Convention> lazySet = AVAILABLES;
        synchronized (lazySet) {
            it = AVAILABLES.iterator();
            if (!it.hasNext()) {
                return DEFAULT;
            }
            c = it.next();
        }
        while (!c.isApplicableTo(decoder)) {
            lazySet = AVAILABLES;
            synchronized (lazySet) {
                if (!it.hasNext()) {
                    c = DEFAULT;
                    break;
                }
                c = it.next();
            }
        }
        return c;
    }

    protected boolean isApplicableTo(Decoder decoder) {
        return false;
    }

    public String[] getSearchPath() {
        return (String[])SEARCH_PATH.clone();
    }

    public String mapAttributeName(String name) {
        return name;
    }

    public VariableRole roleOf(Variable variable) {
        if (variable.isCoordinateSystemAxis()) {
            return VariableRole.AXIS;
        }
        int numVectors = 0;
        for (Dimension dimension : variable.getGridDimensions()) {
            if (dimension.length() < 2L) continue;
            ++numVectors;
        }
        if (numVectors >= 2) {
            DataType dataType = variable.getDataType();
            if (dataType.rasterDataType != 32) {
                return VariableRole.COVERAGE;
            }
        }
        return VariableRole.OTHER;
    }

    public String[] namesOfAxisVariables(Variable data) {
        return null;
    }

    public String nameOfDimension(Variable dataOrAxis, int index) {
        return dataOrAxis.getAttributeAsString("dim" + index);
    }

    public double gridToDataIndices(Variable axis) {
        return axis.getAttributeAsNumber("resampling_interval");
    }

    public Set<Linearizer> linearizers(Decoder decoder) {
        return Collections.emptySet();
    }

    public Set<String> nameOfMappingNode(Variable data) {
        String mapping = data.getAttributeAsString("grid_mapping");
        return mapping != null ? Collections.singleton(mapping) : Collections.emptySet();
    }

    public Map<String, Object> projection(Node node) {
        String method = node.getAttributeAsString("grid_mapping_name");
        if (method == null) {
            return null;
        }
        HashMap<String, Object> definition = new HashMap<String, Object>();
        definition.put("grid_mapping_name", method);
        block12: for (String name : node.getAttributeNames()) {
            try {
                Object value;
                String ln;
                switch (ln = name.toLowerCase(Locale.US)) {
                    case "grid_mapping_name": {
                        continue block12;
                    }
                    case "towgs84": {
                        Vector values = node.getAttributeAsVector(name);
                        if (values == null || values.size() < 3) continue block12;
                        BursaWolfParameters bp = new BursaWolfParameters(CommonCRS.WGS84.datum(), null);
                        bp.setValues(values.doubleValues());
                        value = bp;
                        break;
                    }
                    case "crs_wkt": {
                        continue block12;
                    }
                    default: {
                        if (ln.endsWith("_name") && (value = node.getAttributeAsString(name)) == null || (value = node.getAttributeValue(name)) == null) continue block12;
                        if (!(value instanceof Vector)) break;
                        value = ((Vector)value).doubleValues();
                    }
                }
                if (definition.putIfAbsent(name, value) == null) continue;
                node.error(Convention.class, "projection", null, (short)25, name);
            }
            catch (NumberFormatException e) {
                node.decoder.illegalAttributeValue(name, node.getAttributeAsString(name), e);
            }
        }
        return definition;
    }

    public MathTransform gridToCRS(Node node, MathTransform baseToCRS) throws TransformException {
        return null;
    }

    public CommonCRS defaultHorizontalCRS(boolean spherical) {
        return spherical ? CommonCRS.SPHERE : CommonCRS.GRS1980;
    }

    public NumberRange<?> validRange(Variable data) {
        Number minimum = null;
        Number maximum = null;
        Class<? extends Number> type = null;
        for (String attribute : RANGE_ATTRIBUTES) {
            Vector values = data.getAttributeAsVector(attribute);
            if (values != null) {
                int length = values.size();
                for (int i = 0; i < length; ++i) {
                    try {
                        Number value = values.get(i);
                        if (value instanceof Float) {
                            float fp = ((Float)value).floatValue();
                            if (fp == Float.MAX_VALUE) {
                                value = Float.valueOf(Float.POSITIVE_INFINITY);
                            } else if (fp == -3.4028235E38f) {
                                value = Float.valueOf(Float.NEGATIVE_INFINITY);
                            }
                        } else if (value instanceof Double) {
                            double fp = (Double)value;
                            if (fp == Double.MAX_VALUE) {
                                value = Double.POSITIVE_INFINITY;
                            } else if (fp == -1.7976931348623157E308) {
                                value = Double.NEGATIVE_INFINITY;
                            }
                        }
                        type = Numbers.widestClass(type, value.getClass());
                        minimum = Numbers.cast(minimum, type);
                        maximum = Numbers.cast(maximum, type);
                        value = Numbers.cast(value, type);
                        if (!(attribute.endsWith("max") || minimum != null && Convention.compare(value, minimum) >= 0)) {
                            minimum = value;
                        }
                        if (attribute.endsWith("min") || maximum != null && Convention.compare(value, maximum) <= 0) continue;
                        maximum = value;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        data.decoder.illegalAttributeValue(attribute, values.stringValue(i), e);
                    }
                }
            }
            if (minimum == null || maximum == null) continue;
            byte rangeType = Numbers.getEnumConstant(type);
            if (rangeType >= data.getDataType().number && rangeType >= Math.max(Numbers.getEnumConstant(data.getAttributeType("scale_factor")), Numbers.getEnumConstant(data.getAttributeType("add_offset")))) {
                MeasurementRange<Number> range = new MeasurementRange<Number>(type, minimum, true, maximum, true, data.getUnit());
                return range;
            }
            NumberRange<Object> range = new NumberRange<Object>((Class<Object>)type, minimum, true, maximum, true);
            return range;
        }
        return null;
    }

    private static int compare(Number n1, Number n2) {
        return ((Comparable)((Object)n1)).compareTo((Comparable)((Object)n2));
    }

    public Map<Number, Object> nodataValues(Variable data) {
        LinkedHashMap<Number, Object> pads = new LinkedHashMap<Number, Object>();
        for (int i = 0; i < NODATA_ATTRIBUTES.length; ++i) {
            String name = NODATA_ATTRIBUTES[i];
            Vector values = data.getAttributeAsVector(name);
            if (values == null) continue;
            int length = values.size();
            for (int j = 0; j < length; ++j) {
                try {
                    pads.merge(values.get(j), 1 << i, (v1, v2) -> (Integer)v1 | (Integer)v2);
                    continue;
                }
                catch (NumberFormatException e) {
                    data.decoder.illegalAttributeValue(name, values.stringValue(i), e);
                }
            }
        }
        return pads;
    }

    public TransferFunction transferFunction(Variable data) {
        TransferFunction tr = new TransferFunction();
        double scale = data.getAttributeAsNumber("scale_factor");
        double offset = data.getAttributeAsNumber("add_offset");
        if (!Double.isNaN(scale)) {
            tr.setScale(scale);
        }
        if (!Double.isNaN(offset)) {
            tr.setOffset(offset);
        }
        return tr;
    }
}

