/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.Shutdown;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;

public abstract class Initializer {
    public static final String DATABASE = "SpatialMetadata";
    private static final String DERBY_HOME_KEY = "derby.system.home";
    public static final String JNDI = "jdbc/SpatialMetadata";
    public static final String EMBEDDED = "Embedded";
    @Deprecated
    private static URLClassLoader javadbLoader;
    private static Supplier<DataSource> supplier;
    private static DataSource source;
    private static boolean connected;

    protected Initializer() {
    }

    protected abstract void createSchema(Connection var1) throws SQLException;

    protected abstract void dataSourceChanged();

    public static synchronized boolean setDefault(Supplier<DataSource> ds) {
        if (source == null) {
            supplier = ds;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DataSource getDataSource() throws Exception {
        if (source == null) {
            if (Initializer.hasJNDI()) {
                try {
                    Context env = (Context)InitialContext.doLookup("java:comp/env");
                    source = (DataSource)env.lookup(JNDI);
                    if (env instanceof EventContext) {
                        Listener.register((EventContext)env);
                    }
                    return source;
                }
                catch (NameNotFoundException e) {
                    LogRecord record = Messages.getResources(null).getLogRecord(Level.CONFIG, (short)24, JNDI);
                    record.setLoggerName("org.apache.sis.sql");
                    Logging.log(null, null, record);
                }
            }
            if (supplier != null && (source = supplier.get()) != null) {
                supplier = null;
                return source;
            }
            boolean create = false;
            boolean isEnvClear = DataDirectory.isEnvClear();
            if (!isEnvClear || (source = Initializer.embedded()) == null) {
                String dbURL;
                Path path;
                String home = AccessController.doPrivileged(() -> System.getProperty(DERBY_HOME_KEY));
                Path dir = DataDirectory.DATABASES.getDirectory();
                if (dir != null) {
                    path = dir.resolve(DATABASE);
                    if (home != null) {
                        try {
                            path = Paths.get(home, new String[0]).relativize(path);
                        }
                        catch (IllegalArgumentException | SecurityException e) {
                            Logging.recoverableException(Logging.getLogger("org.apache.sis.sql"), Initializer.class, "getDataSource", e);
                        }
                    }
                    create = !Files.exists(path = path.normalize(), new LinkOption[0]);
                    dbURL = path.toString().replace(path.getFileSystem().getSeparator(), "/");
                } else if (home != null) {
                    path = Paths.get(home, new String[0]);
                    create = !Files.exists(path.resolve(DATABASE), new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
                    dbURL = DATABASE;
                } else {
                    create = true;
                    dbURL = null;
                }
                if (create & !isEnvClear) {
                    source = Initializer.embedded();
                    boolean bl = create = source == null;
                }
                if (source == null) {
                    if (dbURL == null) {
                        return null;
                    }
                    source = Initializer.forJavaDB(dbURL);
                }
            }
            supplier = null;
            Shutdown.register(() -> {
                Initializer.shutdown();
                return null;
            });
            if (create) {
                Method m = source.getClass().getMethod("setCreateDatabase", String.class);
                m.invoke((Object)source, "create");
                try (Connection c = source.getConnection();){
                    for (Initializer init : DefaultFactories.createServiceLoader(Initializer.class)) {
                        init.createSchema(c);
                    }
                }
                catch (Throwable throwable) {
                    m.invoke((Object)source, "no");
                    throw throwable;
                }
                m.invoke((Object)source, "no");
            }
        }
        return source;
    }

    public static boolean hasJNDI() {
        return NamingManager.hasInitialContextFactoryBuilder() || AccessController.doPrivileged(() -> System.getProperty("java.naming.factory.initial") != null) != false;
    }

    private static DataSource embedded() {
        for (InstallationResources res : DefaultFactories.createServiceLoader(InstallationResources.class)) {
            if (!res.getAuthorities().contains(EMBEDDED)) continue;
            try {
                String[] names = res.getResourceNames(EMBEDDED);
                for (int i = 0; i < names.length; ++i) {
                    Object ds;
                    if (!DATABASE.equals(names[i]) || !((ds = res.getResource(EMBEDDED, i)) instanceof DataSource)) continue;
                    return (DataSource)ds;
                }
            }
            catch (IOException e) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.sql"), Initializer.class, "getDataSource", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogRecord connected(DatabaseMetaData metadata) throws SQLException {
        Class<Initializer> clazz = Initializer.class;
        synchronized (Initializer.class) {
            Level level = connected ? Level.FINE : Level.CONFIG;
            connected = true;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            LogRecord record = Messages.getResources(null).getLogRecord(level, (short)6, SQLUtilities.getSimplifiedURL(metadata));
            record.setLoggerName("org.apache.sis.system");
            return record;
        }
    }

    public static Object unspecified(Locale locale, boolean asLog) {
        String value;
        short key;
        if (Initializer.hasJNDI()) {
            key = 24;
            value = JNDI;
        } else {
            key = 16;
            value = "SIS_DATA";
        }
        Messages resources = Messages.getResources(locale);
        return asLog ? resources.getLogRecord(Level.WARNING, key, value) : resources.getString(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSource forJavaDB(String path) throws Exception {
        try {
            return Initializer.forJavaDB(path, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            Class<Initializer> clazz = Initializer.class;
            synchronized (Initializer.class) {
                Path file;
                String home;
                URLClassLoader loader = javadbLoader;
                if (loader == null && (home = System.getProperty("java.home")) != null && Files.isRegularFile(file = Paths.get(home, new String[0]).resolveSibling("db/lib/derby.jar"), new LinkOption[0])) {
                    javadbLoader = loader = new URLClassLoader(new URL[]{file.toUri().toURL(), file.resolveSibling("derbynet.jar").toUri().toURL()});
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (loader == null) {
                    throw e;
                }
                return Initializer.forJavaDB(path, loader);
            }
        }
    }

    private static DataSource forJavaDB(String path, ClassLoader loader) throws Exception {
        Class<?> c = Class.forName("org.apache.derby.jdbc.EmbeddedDataSource", true, loader);
        DataSource ds = (DataSource)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class[] args = new Class[]{String.class};
        c.getMethod("setDatabaseName", args).invoke((Object)ds, path);
        c.getMethod("setDataSourceName", args).invoke((Object)ds, "Apache SIS spatial metadata");
        return ds;
    }

    private static synchronized void shutdown() throws ReflectiveOperationException {
        DataSource ds = source;
        if (ds != null) {
            source = null;
            connected = false;
            ds.getClass().getMethod("setShutdownDatabase", String.class).invoke((Object)ds, "shutdown");
            try {
                ds.getConnection().close();
            }
            catch (SQLException e) {
                LogRecord record = new LogRecord(Level.FINE, e.getMessage());
                if (!Initializer.isSuccessfulShutdown(e)) {
                    record.setLevel(Level.WARNING);
                    record.setThrown(e);
                }
                record.setLoggerName("org.apache.sis.sql");
                Logging.log(Initializer.class, "shutdown", record);
            }
        }
    }

    public static boolean isSuccessfulShutdown(SQLException e) {
        String state = e.getSQLState();
        return "08006".equals(state) || "XJ004".equals(state);
    }

    private static final class Listener
    implements ObjectChangeListener,
    Callable<Object> {
        private final EventContext context;

        private Listener(EventContext context) {
            this.context = context;
        }

        static void register(EventContext context) throws NamingException {
            Listener listener = new Listener(context);
            context.addNamingListener(Initializer.JNDI, 0, (NamingListener)listener);
            Shutdown.register(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws NamingException {
            Class<Initializer> clazz = Initializer.class;
            synchronized (Initializer.class) {
                this.context.removeNamingListener(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void objectChanged(NamingEvent event) {
            try {
                Class<Initializer> clazz = Initializer.class;
                synchronized (Initializer.class) {
                    source = null;
                    connected = false;
                    Shutdown.unregister(this);
                    this.context.removeNamingListener(this);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (NamingException e) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), Listener.class, "objectChanged", e);
            }
            {
                for (Initializer init : DefaultFactories.createServiceLoader(Initializer.class)) {
                    init.dataSourceChanged();
                }
                return;
            }
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent event) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.system"), Listener.class, "namingExceptionThrown", event.getException());
            this.objectChanged(null);
        }
    }
}

