/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.sis.util.CharSequences;

public enum Dialect {
    ANSI(null, false),
    DERBY("derby", false),
    HSQL("hsqldb", false),
    POSTGRESQL("postgresql", true),
    ORACLE("oracle", false);

    private final String protocol;
    public final boolean isTableInheritanceSupported;
    public final boolean isIndexInheritanceSupported = false;

    private Dialect(String protocol, boolean isTableInheritanceSupported) {
        this.protocol = protocol;
        this.isTableInheritanceSupported = isTableInheritanceSupported;
    }

    public static Dialect guess(DatabaseMetaData metadata) throws SQLException {
        int end;
        int start;
        String url = metadata.getURL();
        if (url != null && (start = url.indexOf(58)) >= 0 && "jdbc".equalsIgnoreCase((String)CharSequences.trimWhitespaces(url, 0, start)) && (end = url.indexOf(58, ++start)) >= 0) {
            String protocol = (String)CharSequences.trimWhitespaces(url, start, end);
            for (Dialect candidate : Dialect.values()) {
                if (!protocol.equalsIgnoreCase(candidate.protocol)) continue;
                return candidate;
            }
        }
        return ANSI;
    }
}

