/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.Classes;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.resources.Errors;

public class Merger {
    private final Map<Object, Boolean> done = new IdentityHashMap<Object, Boolean>();
    protected final Locale locale;

    public Merger(Locale locale) {
        this.locale = locale;
    }

    private Errors errors() {
        return Errors.getResources(this.locale);
    }

    private static String name(ModifiableMetadata target, String propertyName) {
        return Classes.getShortName(target.getInterface()) + '.' + propertyName;
    }

    public final void copy(Object source, ModifiableMetadata target) {
        if (!this.copy(source, target, false)) {
            throw new InvalidMetadataException(this.errors().getString((short)43, "target", target.getStandard().getInterface(source.getClass()), Classes.getClass(target)));
        }
    }

    private boolean copy(Object source, ModifiableMetadata target, boolean dryRun) {
        MetadataStandard standard = target.getStandard();
        if (!standard.getInterface(source.getClass()).isInstance(target)) {
            return false;
        }
        Boolean sourceDone = this.done.put(source, Boolean.FALSE);
        Boolean targetDone = this.done.put(target, Boolean.TRUE);
        if (sourceDone != null || targetDone != null) {
            if (Boolean.FALSE.equals(sourceDone) && Boolean.TRUE.equals(targetDone)) {
                return true;
            }
            throw new IllegalArgumentException(this.errors().getString((short)167));
        }
        Map<String, Object> targetMap = target.asMap();
        Map<String, Object> sourceMap = source instanceof AbstractMetadata ? ((AbstractMetadata)source).asMap() : standard.asValueMap(source, null, KeyNamePolicy.JAVABEANS_PROPERTY, ValueExistencePolicy.NON_EMPTY);
        boolean success = true;
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            String propertyName = entry.getKey();
            Object sourceValue = entry.getValue();
            Object targetValue = dryRun ? targetMap.get(propertyName) : targetMap.putIfAbsent(propertyName, sourceValue);
            if (targetValue == null) continue;
            if (targetValue instanceof ModifiableMetadata) {
                success = this.copy(sourceValue, (ModifiableMetadata)targetValue, dryRun);
                if (success) continue;
                if (dryRun) break;
                throw new InvalidMetadataException(this.errors().getString((short)59, Merger.name(target, propertyName), ((ModifiableMetadata)targetValue).getInterface(), Classes.getClass(sourceValue)));
            }
            if (targetValue instanceof Collection) {
                if (dryRun) continue;
                Collection targetList = (Collection)targetValue;
                LinkedList sourceList = new LinkedList((Collection)sourceValue);
                block6: for (Object element : targetList) {
                    if (!(element instanceof ModifiableMetadata)) continue;
                    Iterator it = sourceList.iterator();
                    while (it.hasNext()) {
                        Object value = it.next();
                        switch (this.resolve(value, (ModifiableMetadata)element)) {
                            default: {
                                throw new UnsupportedOperationException();
                            }
                            case SEPARATE: {
                                break;
                            }
                            case MERGE: {
                                if (!this.copy(value, (ModifiableMetadata)element, false)) break;
                            }
                            case IGNORE: {
                                it.remove();
                                continue block6;
                            }
                        }
                    }
                }
                for (Object element : sourceList) {
                    Collection oldList;
                    Object old = targetMap.put(propertyName, element);
                    if (old instanceof Collection && (oldList = (Collection)old).size() <= targetList.size()) {
                        assert (targetList.containsAll(oldList)) : propertyName;
                        continue;
                    }
                    throw new InvalidMetadataException(this.errors().getString((short)160, Classes.getShortClassName(targetList)));
                }
                continue;
            }
            if (targetValue instanceof Map) {
                success = new ForMap(target, propertyName, (Map)sourceValue, (Map)targetValue).run(dryRun);
                continue;
            }
            success = targetValue.equals(sourceValue);
            if (success) continue;
            if (dryRun) break;
            this.merge(target, propertyName, sourceValue, targetValue);
            success = true;
        }
        if (!(!dryRun || Boolean.FALSE.equals(this.done.remove(source)) && Boolean.TRUE.equals(this.done.remove(target)))) {
            throw new CorruptedObjectException();
        }
        return success;
    }

    protected Resolution resolve(Object source, ModifiableMetadata target) {
        return this.copy(source, target, true) ? Resolution.MERGE : Resolution.SEPARATE;
    }

    protected void merge(ModifiableMetadata target, String propertyName, Object sourceValue, Object targetValue) {
        throw new InvalidMetadataException(this.errors().getString((short)164, Merger.name(target, propertyName)));
    }

    public static enum Resolution {
        MERGE,
        SEPARATE,
        IGNORE;

    }

    private final class ForMap<V>
    implements BiFunction<V, V, V> {
        private final ModifiableMetadata parent;
        private final String property;
        private final Map<?, ?> source;
        private final Map<?, ?> target;

        ForMap(ModifiableMetadata parent, String property, Map<?, ?> source, Map<?, ?> target) {
            this.parent = parent;
            this.property = property;
            this.source = source;
            this.target = target;
        }

        final boolean run(boolean dryRun) {
            for (Map.Entry<?, ?> pe : this.source.entrySet()) {
                Object newValue = pe.getValue();
                if (dryRun) {
                    Object oldValue;
                    if (newValue == null || (oldValue = this.target.get(pe.getKey())) == null || newValue instanceof ModifiableMetadata && Merger.this.copy(oldValue, (ModifiableMetadata)newValue, true)) continue;
                    return false;
                }
                this.target.merge(pe.getKey(), newValue, this);
            }
            return true;
        }

        @Override
        public V apply(V oldValue, V newValue) {
            if (newValue instanceof ModifiableMetadata) {
                switch (Merger.this.resolve(oldValue, (ModifiableMetadata)newValue)) {
                    default: {
                        throw new UnsupportedOperationException();
                    }
                    case IGNORE: {
                        break;
                    }
                    case MERGE: {
                        if (Merger.this.copy(oldValue, (ModifiableMetadata)newValue, false)) break;
                        Merger.this.merge(this.parent, this.property, oldValue, newValue);
                    }
                }
            }
            return newValue != null ? newValue : oldValue;
        }
    }
}

