/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Iterator;
import java.util.Locale;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Static;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Identifiers
extends Static {
    private Identifiers() {
    }

    public static boolean isEPSG(String codeSpace, String code) {
        return "EPSG".equalsIgnoreCase(code) && ("IOGP".equalsIgnoreCase(codeSpace) || "OGP".equalsIgnoreCase(codeSpace) || "EPSG".equalsIgnoreCase(codeSpace));
    }

    private static boolean isDeprecated(Object object) {
        return object instanceof Deprecable && ((Deprecable)object).isDeprecated();
    }

    private static String toString(InternationalString title) {
        return title != null && !Identifiers.isDeprecated(title) ? CharSequences.trimWhitespaces(title.toString(Locale.ROOT)) : null;
    }

    public static String getIdentifier(Citation citation, boolean strict) {
        if (citation != null) {
            String candidate;
            boolean isUnicode = false;
            String identifier = null;
            String codeSpace = null;
            Iterator it = CollectionsExt.nonEmptyIterator(citation.getIdentifiers());
            if (it != null) {
                while (it.hasNext()) {
                    Identifier id = (Identifier)it.next();
                    if (id == null || Identifiers.isDeprecated(id) || (candidate = CharSequences.trimWhitespaces(id.getCode())) == null || candidate.isEmpty()) continue;
                    String cs = null;
                    if (id instanceof ReferenceIdentifier) {
                        cs = CharSequences.trimWhitespaces(((ReferenceIdentifier)id).getCodeSpace());
                    }
                    if (cs == null || cs.isEmpty()) {
                        cs = null;
                        isUnicode = CharSequences.isUnicodeIdentifier(candidate);
                    } else {
                        isUnicode = CharSequences.isUnicodeIdentifier(cs);
                        if (isUnicode) {
                            int c;
                            for (int i = 0; i < candidate.length(); i += Character.charCount(c)) {
                                c = candidate.codePointAt(i);
                                if (Character.isUnicodeIdentifierPart(c) || !strict && (c == 46 || c == 45)) continue;
                                isUnicode = false;
                                break;
                            }
                        }
                    }
                    if (identifier != null && !isUnicode) continue;
                    identifier = candidate;
                    codeSpace = cs;
                    if (!isUnicode) continue;
                    break;
                }
            }
            if (identifier == null) {
                Iterator iterator;
                identifier = Identifiers.toString(citation.getTitle());
                if (identifier != null) {
                    if (identifier.isEmpty()) {
                        identifier = null;
                    } else {
                        isUnicode = CharSequences.isUnicodeIdentifier(identifier);
                    }
                }
                if (!isUnicode && (iterator = CollectionsExt.nonEmptyIterator(citation.getAlternateTitles())) != null) {
                    while (iterator.hasNext()) {
                        candidate = Identifiers.toString((InternationalString)iterator.next());
                        if (candidate == null || candidate.isEmpty()) continue;
                        isUnicode = CharSequences.isUnicodeIdentifier(candidate);
                        if (identifier != null && !isUnicode) continue;
                        identifier = candidate;
                        if (!isUnicode) continue;
                        break;
                    }
                }
            }
            if (isUnicode || !strict) {
                if (codeSpace != null && !Identifiers.isEPSG(codeSpace, identifier)) {
                    return codeSpace + (strict ? (char)'_' : ':') + identifier;
                }
                return identifier;
            }
        }
        return null;
    }

    private static boolean authorityMatches(Identifier identifier, Citation authority, String codeSpace) {
        Object other;
        if (authority != null && (other = identifier.getAuthority()) != null) {
            return Citations.identifierMatches(authority, other);
        }
        if (codeSpace != null && identifier instanceof ReferenceIdentifier && (other = ((ReferenceIdentifier)identifier).getCodeSpace()) != null) {
            return CharSequences.equalsFiltered(codeSpace, (CharSequence)other, Characters.Filter.UNICODE_IDENTIFIER, true);
        }
        return false;
    }

    public static Boolean hasCommonIdentifier(Iterable<? extends ReferenceIdentifier> id1, Iterable<? extends ReferenceIdentifier> id2) {
        if (id1 != null && id2 != null) {
            boolean hasFound = false;
            for (ReferenceIdentifier referenceIdentifier : id1) {
                Citation authority = referenceIdentifier.getAuthority();
                String codeSpace = referenceIdentifier.getCodeSpace();
                for (Identifier identifier : id2) {
                    if (!Identifiers.authorityMatches((Identifier)referenceIdentifier, authority, codeSpace)) continue;
                    if (CharSequences.equalsFiltered(referenceIdentifier.getCode(), identifier.getCode(), Characters.Filter.UNICODE_IDENTIFIER, true)) {
                        return Boolean.TRUE;
                    }
                    hasFound = true;
                }
            }
            if (hasFound) {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

