/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk9;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.sis.internal.util.UnmodifiableArrayList;

public final class JDK9 {
    private JDK9() {
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(elements[0]);
            }
        }
        return UnmodifiableArrayList.wrap(elements);
    }

    @SafeVarargs
    public static <E> Set<E> setOf(E ... elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(elements[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(elements)));
    }

    public static Buffer slice(Buffer b) {
        if (b instanceof ByteBuffer) {
            return ((ByteBuffer)b).slice();
        }
        if (b instanceof ShortBuffer) {
            return ((ShortBuffer)b).slice();
        }
        if (b instanceof IntBuffer) {
            return ((IntBuffer)b).slice();
        }
        if (b instanceof LongBuffer) {
            return ((LongBuffer)b).slice();
        }
        if (b instanceof FloatBuffer) {
            return ((FloatBuffer)b).slice();
        }
        if (b instanceof DoubleBuffer) {
            return ((DoubleBuffer)b).slice();
        }
        throw new IllegalArgumentException();
    }

    public static Buffer duplicate(Buffer b) {
        if (b instanceof ByteBuffer) {
            return ((ByteBuffer)b).duplicate();
        }
        if (b instanceof ShortBuffer) {
            return ((ShortBuffer)b).duplicate();
        }
        if (b instanceof IntBuffer) {
            return ((IntBuffer)b).duplicate();
        }
        if (b instanceof LongBuffer) {
            return ((LongBuffer)b).duplicate();
        }
        if (b instanceof FloatBuffer) {
            return ((FloatBuffer)b).duplicate();
        }
        if (b instanceof DoubleBuffer) {
            return ((DoubleBuffer)b).duplicate();
        }
        throw new IllegalArgumentException();
    }
}

