/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public final class CC_OperationParameter
extends PropertyType<CC_OperationParameter, ParameterDescriptor<?>> {
    public Class<?> valueClass;
    public MeasurementRange<?> valueDomain;

    public CC_OperationParameter() {
    }

    @Override
    protected Class<ParameterDescriptor<?>> getBoundType() {
        return ParameterDescriptor.class;
    }

    private CC_OperationParameter(ParameterDescriptor<?> parameter) {
        super(parameter);
    }

    @Override
    protected CC_OperationParameter wrap(ParameterDescriptor<?> parameter) {
        return new CC_OperationParameter(parameter);
    }

    @XmlElement(name="OperationParameter")
    public DefaultParameterDescriptor<?> getElement() {
        return DefaultParameterDescriptor.castOrCopy((ParameterDescriptor)this.metadata);
    }

    public void setElement(DefaultParameterDescriptor<?> parameter) {
        this.metadata = parameter;
    }

    private void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) {
        Object value;
        if (parent instanceof ParameterValue && (value = ((ParameterValue)parent).getValue()) != null) {
            this.valueClass = value.getClass();
            Unit<Angle> unit = ((ParameterValue)parent).getUnit();
            if (unit != null) {
                if (Units.RADIAN.equals((Object)(unit = unit.getSystemUnit()))) {
                    unit = Units.DEGREE;
                }
                assert (this.valueClass == Double.class || this.valueClass == double[].class) : this.valueClass;
                this.valueDomain = MeasurementRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false, unit);
            }
            Context.setWrapper(Context.current(), this);
        }
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        Context.setWrapper(Context.current(), null);
    }
}

