/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.lan;

import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.util.Bag;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;

public final class LocaleAndCharset
implements TreeTable.Node {
    private final TreeTable.Node node;

    public LocaleAndCharset(TreeTable.Node node) {
        this.node = node;
    }

    @Override
    public TreeTable.Node getParent() {
        return this.node.getParent();
    }

    @Override
    public boolean isEditable(TableColumn<?> column) {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    private static Object keyOrValue(Object object, boolean key) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            object = key ? entry.getKey() : entry.getValue();
        }
        return object;
    }

    @Override
    public Object getUserObject() {
        return LocaleAndCharset.keyOrValue(this.node.getUserObject(), true);
    }

    @Override
    public <V> V getValue(TableColumn<V> column) {
        return this.separateValue(column, true);
    }

    private <V> V separateValue(TableColumn<V> column, boolean key) {
        V value = this.node.getValue(column);
        if (TableColumn.VALUE.equals(column)) {
            value = column.getElementType().cast(LocaleAndCharset.keyOrValue(value, key));
        }
        return value;
    }

    @Override
    public <V> void setValue(TableColumn<V> column, V value) {
        if (TableColumn.VALUE.equals(column)) {
            throw new UnsupportedOperationException();
        }
        this.node.setValue(column, value);
    }

    @Override
    public Collection<TreeTable.Node> getChildren() {
        return new AbstractList<TreeTable.Node>(){

            @Override
            public int size() {
                return LocaleAndCharset.keyOrValue(LocaleAndCharset.this.node.getUserObject(), false) != null ? 1 : 0;
            }

            @Override
            public TreeTable.Node get(int index) {
                ArgumentChecks.ensureValidIndex(1, index);
                return new Child();
            }
        };
    }

    @Override
    public TreeTable.Node newChild() {
        if (LocaleAndCharset.keyOrValue(this.node.getUserObject(), false) != null) {
            throw new UnsupportedOperationException();
        }
        return new Child();
    }

    @Override
    public int hashCode() {
        return this.node.hashCode() ^ 0x25;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof LocaleAndCharset && this.node.equals(((LocaleAndCharset)other).node);
    }

    public static Collection<Locale> getLanguages(final Map<Locale, Charset> locales) {
        if (locales == null) {
            return null;
        }
        return new AbstractSet<Locale>(){

            @Override
            public int size() {
                return locales.size();
            }

            @Override
            public void clear() {
                locales.clear();
            }

            @Override
            public boolean contains(Object o) {
                return locales.containsKey(o);
            }

            @Override
            public Iterator<Locale> iterator() {
                return locales.keySet().iterator();
            }

            @Override
            public boolean add(Locale locale) {
                if (locale == null || locales.containsKey(locale)) {
                    return false;
                }
                Charset encoding = (Charset)locales.remove(null);
                locales.put(locale, encoding);
                return true;
            }
        };
    }

    public static Collection<Charset> getCharacterSets(final Map<Locale, Charset> locales) {
        if (locales == null) {
            return null;
        }
        return new Bag<Charset>(){

            @Override
            public int size() {
                return locales.size();
            }

            @Override
            public void clear() {
                locales.clear();
            }

            @Override
            public boolean contains(Object o) {
                return locales.containsValue(o);
            }

            @Override
            public Iterator<Charset> iterator() {
                return locales.values().iterator();
            }

            @Override
            public boolean add(Charset encoding) {
                if (encoding == null) {
                    return false;
                }
                for (Map.Entry entry : locales.entrySet()) {
                    if (entry.getValue() != null) continue;
                    entry.setValue(encoding);
                    return true;
                }
                return locales.putIfAbsent(null, encoding) != encoding;
            }
        };
    }

    public static Map<Locale, Charset> setLanguages(Map<Locale, Charset> locales, Collection<? extends Locale> newValues) {
        Charset encoding;
        Charset charset = encoding = locales != null ? CollectionsExt.first(locales.values()) : null;
        if (newValues == null || newValues.isEmpty()) {
            if (locales != null) {
                locales.clear();
            }
        } else {
            if (locales == null) {
                locales = new LinkedHashMap<Locale, Charset>();
            }
            locales.keySet().retainAll(newValues);
            for (Locale locale : newValues) {
                locales.putIfAbsent(locale, null);
            }
        }
        if (encoding != null && !locales.values().contains(encoding)) {
            locales.put(null, encoding);
        }
        return locales;
    }

    public static Map<Locale, Charset> setCharacterSets(Map<Locale, Charset> locales, Collection<? extends Charset> newValues) {
        Charset encoding = CollectionsExt.first(newValues);
        if (locales != null || encoding != null) {
            if (locales == null) {
                locales = new LinkedHashMap<Locale, Charset>();
            }
            if (locales.isEmpty()) {
                locales.put(null, encoding);
            } else {
                for (Map.Entry<Locale, Charset> entry : locales.entrySet()) {
                    entry.setValue(encoding);
                }
            }
        }
        return locales;
    }

    private final class Child
    implements TreeTable.Node {
        private Child() {
        }

        @Override
        public TreeTable.Node getParent() {
            return LocaleAndCharset.this;
        }

        @Override
        public Object getUserObject() {
            return LocaleAndCharset.keyOrValue(LocaleAndCharset.this.node.getUserObject(), false);
        }

        @Override
        public boolean isEditable(TableColumn<?> c) {
            return LocaleAndCharset.this.node.isEditable(c);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Collection<TreeTable.Node> getChildren() {
            return Collections.emptySet();
        }

        @Override
        public TreeTable.Node newChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> V getValue(TableColumn<V> column) {
            String value;
            if (TableColumn.IDENTIFIER.equals(column)) {
                value = "characterSet";
            } else if (TableColumn.NAME.equals(column)) {
                value = "Character set";
            } else {
                return (V)LocaleAndCharset.this.separateValue(column, false);
            }
            return column.getElementType().cast(value);
        }

        @Override
        public <V> void setValue(TableColumn<V> column, V value) {
            if (TableColumn.VALUE.equals(column)) {
                ((Map.Entry)LocaleAndCharset.this.node.getUserObject()).setValue(value);
            } else {
                LocaleAndCharset.this.node.setValue(column, value);
            }
        }

        @Override
        public int hashCode() {
            return ~this.getParent().hashCode();
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof Child && this.getParent().equals(((Child)other).getParent());
        }
    }
}

