/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.lan;

import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.cat.CodeListUID;
import org.apache.sis.internal.jaxb.gco.CharSequenceAdapter;
import org.apache.sis.internal.jaxb.gco.GO_CharacterString;
import org.apache.sis.internal.jaxb.lan.LanguageCode;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

@XmlType(name="Country_PropertyType")
public final class Country
extends GO_CharacterString {
    private CodeListUID identifier;
    private boolean isLegacyMetadata;

    private Country() {
    }

    private Country(CharSequence code) {
        super(code);
        this.detectVersion();
    }

    private Country(Context context, String codeListValue, String codeSpace, String value) {
        this.identifier = new CodeListUID(context, "Country", codeListValue, codeSpace, value);
        this.detectVersion();
    }

    private void detectVersion() {
        this.isLegacyMetadata = !FilterByVersion.CURRENT_METADATA.accept();
    }

    @XmlElement(name="Country", namespace="http://www.isotc211.org/2005/gmd")
    private CodeListUID getCountry() {
        return this.isLegacyMetadata ? this.identifier : null;
    }

    private void setCountry(CodeListUID newValue) {
        this.identifier = newValue;
    }

    @XmlElement(name="CountryCode")
    private CodeListUID getCountryCode() {
        return this.isLegacyMetadata ? null : this.identifier;
    }

    private void setCountryCode(CodeListUID newValue) {
        this.identifier = newValue;
    }

    public static Country create(Context context, Locale locale) {
        String codeListValue = Context.converter(context).toCountryCode(context, locale);
        if (codeListValue != null) {
            CharSequence string;
            if (!codeListValue.isEmpty() && Context.isFlagSet(context, 4) && (string = CharSequenceAdapter.value(context, locale, codeListValue)) != null) {
                return new Country(string);
            }
            Locale marshalLocale = LanguageCode.marshalLocale(context);
            String codeSpace = Context.converter(context).toLanguageCode(context, marshalLocale);
            String value = locale.getDisplayCountry(marshalLocale);
            if (value.isEmpty()) {
                codeSpace = null;
                value = null;
            }
            if (!codeListValue.isEmpty() || value != null) {
                return new Country(context, codeListValue, codeSpace, value);
            }
        }
        return null;
    }

    public static Locale getLocale(Context context, LanguageCode language, Country country, Class<?> caller) {
        CodeListUID identifier;
        String c;
        String code = null;
        if (language != null) {
            code = language.getLanguage();
        }
        if (country != null && (c = CharSequences.trimWhitespaces(((identifier = country.identifier) != null ? identifier : country).toString())) != null && !c.isEmpty()) {
            int i;
            if (code == null) {
                code = "";
            }
            if ((i = code.indexOf(95)) < 0) {
                code = code + '_' + c;
            } else {
                int length = code.length();
                if (++i == code.length() || code.charAt(i) == '_') {
                    code = new StringBuilder().append(code, 0, i).append(c).append(code, i, length).toString();
                } else if (!c.equals(CharSequences.token(code, i))) {
                    Context.warningOccured(context, caller, "unmarshal", Errors.class, (short)63, "country");
                }
            }
        }
        return Context.converter(context).toLocale(context, code);
    }
}

