/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.measure.Unit;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gml.Measure;

public class UnitAdapter
extends XmlAdapter<String, Unit<?>> {
    public final Unit<?> unmarshal(String value) throws IllegalArgumentException {
        Context context = Context.current();
        return Context.converter(context).toUnit(context, value);
    }

    public String marshal(Unit<?> value) {
        return value != null ? value.toString() : null;
    }

    public static final class Since2014
    extends UnitAdapter {
        @Override
        public String marshal(Unit<?> value) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(value) : null;
        }
    }

    public static final class ForCS
    extends UnitAdapter {
        @Override
        public String marshal(Unit<?> value) {
            return Measure.getUOM(value, false, true);
        }
    }
}

