/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.code;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.cat.CodeListUID;
import org.apache.sis.xml.ValueConverter;
import org.opengis.metadata.identification.CharacterSet;

public final class MD_CharacterSetCode
extends XmlAdapter<MD_CharacterSetCode, Charset> {
    private CodeListUID identifier;

    public final Charset unmarshal(MD_CharacterSetCode adapter) throws IllegalCharsetNameException {
        Context context = Context.current();
        return Context.converter(context).toCharset(context, adapter.identifier.toString());
    }

    public final MD_CharacterSetCode marshal(Charset value) {
        Context context = Context.current();
        ValueConverter converter = Context.converter(context);
        String code = converter.toCharsetCode(context, value);
        if (code != null) {
            Locale locale = context.getLocale();
            MD_CharacterSetCode c = new MD_CharacterSetCode();
            c.identifier = new CodeListUID(context, "MD_CharacterSetCode", code, locale != null ? converter.toLanguageCode(context, locale) : null, locale != null ? value.displayName(locale) : value.displayName());
            return c;
        }
        return null;
    }

    @XmlElement(name="MD_CharacterSetCode", namespace="http://standards.iso.org/iso/19115/-3/lan/1.0")
    public CodeListUID getElement() {
        return this.identifier;
    }

    public void setElement(CodeListUID value) {
        this.identifier = value;
    }

    public static CharacterSet fromCharset(Charset cs) {
        if (cs == null) {
            return null;
        }
        String name = cs.name();
        for (CharacterSet candidate : CharacterSet.values()) {
            for (String n : candidate.names()) {
                if (!name.equals(n)) continue;
                return candidate;
            }
        }
        return CharacterSet.valueOf((String)name);
    }
}

