/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.SystemListener;

public abstract class TypeRegistration {
    public static final String ROOT_ADAPTERS = "org.apache.sis.xml.rootAdapters";
    private static Reference<JAXBContext> context;
    private static UnaryOperator<Object>[] converters;
    private static ServiceLoader<TypeRegistration> services;

    protected TypeRegistration() {
    }

    protected abstract void getTypes(Collection<Class<?>> var1);

    protected UnaryOperator<Object> beforeMarshal() {
        return null;
    }

    protected boolean hasRenameFile(boolean export) {
        return false;
    }

    public static synchronized void getRenameFileLoader(boolean export, Set<Class<?>> addTo) {
        for (TypeRegistration t : TypeRegistration.services()) {
            if (!t.hasRenameFile(export)) continue;
            addTo.add(t.getClass());
        }
    }

    private static ServiceLoader<TypeRegistration> services() {
        ServiceLoader<TypeRegistration> s = services;
        if (s == null) {
            services = s = DefaultFactories.createServiceLoader(TypeRegistration.class);
            DelayedExecutor.schedule(new DelayedRunnable(1, TimeUnit.MINUTES){

                @Override
                public void run() {
                    services = null;
                }
            });
        }
        return s;
    }

    private static Class<?>[] load(boolean getTypes) {
        ArrayList types = new ArrayList();
        ArrayList<UnaryOperator<Object>> toImpl = new ArrayList<UnaryOperator<Object>>();
        for (TypeRegistration t : TypeRegistration.services()) {
            UnaryOperator<Object> c;
            if (getTypes) {
                t.getTypes(types);
            }
            if ((c = t.beforeMarshal()) == null) continue;
            toImpl.add(c);
        }
        converters = toImpl.toArray(new UnaryOperator[toImpl.size()]);
        return types.toArray(new Class[types.size()]);
    }

    public static synchronized JAXBContext getSharedContext() throws JAXBException {
        JAXBContext instance;
        Reference<JAXBContext> c = context;
        if (c != null && (instance = c.get()) != null) {
            return instance;
        }
        instance = JAXBContext.newInstance((Class[])TypeRegistration.load(true));
        context = new WeakReference<JAXBContext>(instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ?> getPrivateInfo(Map<String, ?> properties) {
        if (properties != null && properties.containsKey(ROOT_ADAPTERS)) {
            return properties;
        }
        Class<TypeRegistration> clazz = TypeRegistration.class;
        synchronized (TypeRegistration.class) {
            UnaryOperator<Object>[] c = converters;
            if (c == null) {
                TypeRegistration.load(false);
                c = converters;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (properties == null) {
                return Collections.singletonMap(ROOT_ADAPTERS, c);
            }
            HashMap copy = new HashMap(properties);
            copy.put(ROOT_ADAPTERS, c);
            return copy;
        }
    }

    static /* synthetic */ UnaryOperator[] access$102(UnaryOperator[] x0) {
        converters = x0;
        return x0;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.util"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void classpathChanged() {
                Class<TypeRegistration> clazz = TypeRegistration.class;
                synchronized (TypeRegistration.class) {
                    context = null;
                    TypeRegistration.access$102(null);
                    services = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

