/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.IdentifierMapEntry;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.XLink;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;

public final class SpecializedIdentifier<T>
implements ReferenceIdentifier,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1699757455535495848L;
    private final IdentifierSpace<T> authority;
    T value;

    public SpecializedIdentifier(IdentifierSpace<T> authority, T value) {
        this.authority = authority;
        this.value = value;
    }

    static ReferenceIdentifier parse(Citation authority, String code) {
        if (authority instanceof NonMarshalledAuthority) {
            byte ordinal = ((NonMarshalledAuthority)authority).ordinal;
            switch (ordinal) {
                case 0: {
                    return new SpecializedIdentifier<String>(IdentifierSpace.ID, code);
                }
                case 1: {
                    Context context = Context.current();
                    ValueConverter converter = Context.converter(context);
                    try {
                        return new SpecializedIdentifier<UUID>(IdentifierSpace.UUID, converter.toUUID(context, code));
                    }
                    catch (IllegalArgumentException e) {
                        SpecializedIdentifier.parseFailure(context, code, UUID.class, e);
                        break;
                    }
                }
                case 2: 
                case 3: {
                    URI href;
                    Context context = Context.current();
                    ValueConverter converter = Context.converter(context);
                    try {
                        href = converter.toURI((MarshalContext)context, code);
                    }
                    catch (URISyntaxException e) {
                        SpecializedIdentifier.parseFailure(context, code, URI.class, e);
                        break;
                    }
                    if (ordinal == 2) {
                        return new SpecializedIdentifier<URI>(IdentifierSpace.HREF, href);
                    }
                    XLink xlink = new XLink();
                    xlink.setHRef(href);
                    return new SpecializedIdentifier<XLink>(IdentifierSpace.XLINK, xlink);
                }
            }
        }
        return new IdentifierMapEntry(authority, code);
    }

    static void parseFailure(Context context, String value, Class<?> type, Exception cause) {
        Context.warningOccured(context, Level.WARNING, IdentifierMap.class, "put", cause, Messages.class, (short)31, type, value);
    }

    public Citation getAuthority() {
        return this.authority;
    }

    public T getValue() {
        return this.value;
    }

    public String getCode() {
        T value = this.value;
        return value != null ? value.toString() : null;
    }

    public String getCodeSpace() {
        return Citations.toCodeSpace(this.authority);
    }

    public String getVersion() {
        return null;
    }

    public int hashCode() {
        return Objects.hashCode(this.value) + 31 * Objects.hashCode(this.authority);
    }

    public boolean equals(Object other) {
        if (other instanceof SpecializedIdentifier) {
            SpecializedIdentifier that = (SpecializedIdentifier)other;
            return Objects.equals(this.authority, that.authority) && Objects.equals(this.value, that.value);
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(60).append("Identifier[");
        SpecializedIdentifier.format(buffer, this.authority, this.getCode());
        return buffer.append(']').toString();
    }

    static void format(StringBuilder buffer, Citation authority, String code) {
        boolean quote;
        buffer.append(Citations.toCodeSpace(authority)).append('=');
        boolean bl = quote = code != null && code.indexOf(91) < 0;
        if (quote) {
            buffer.append('\u201c');
        }
        buffer.append(code);
        if (quote) {
            buffer.append('\u201d');
        }
    }
}

