/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.simple.CitationConstant;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public final class NonMarshalledAuthority<T>
extends CitationConstant.Authority<T> {
    private static final long serialVersionUID = 6299502270649111201L;
    public static final byte ID = 0;
    public static final byte UUID = 1;
    public static final byte HREF = 2;
    public static final byte XLINK = 3;
    public static final byte ISSN = 4;
    public static final byte ISBN = 5;
    final transient byte ordinal;

    public NonMarshalledAuthority(String attribute, byte ordinal) {
        super(attribute);
        this.ordinal = ordinal;
    }

    public boolean isBookOrSerialNumber() {
        return this.ordinal == 5 || this.ordinal == 4;
    }

    public static <T extends Identifier> T getMarshallable(Collection<? extends T> identifiers) {
        if (identifiers != null) {
            for (Identifier id : identifiers) {
                if (id == null || id.getAuthority() instanceof NonMarshalledAuthority) continue;
                return (T)id;
            }
        }
        return null;
    }

    public static <T extends Identifier> Collection<T> setMarshallable(Collection<T> identifiers, T newValue) {
        if (identifiers == null) {
            return CollectionsExt.singletonOrEmpty(newValue);
        }
        Iterator<T> it = identifiers.iterator();
        while (it.hasNext()) {
            Identifier old = (Identifier)it.next();
            if (old != null && old.getAuthority() instanceof NonMarshalledAuthority) continue;
            it.remove();
        }
        if (newValue != null) {
            identifiers.add(newValue);
        }
        return identifiers;
    }

    public static Collection<Identifier> filterOnMarshalling(Collection<Identifier> identifiers) {
        int count;
        if (identifiers != null && Context.isFlagSet(Context.current(), 1) && (count = identifiers.size()) != 0) {
            Identifier[] copy = identifiers.toArray(new Identifier[count]);
            int i = count;
            while (--i >= 0) {
                Identifier id = copy[i];
                if (id != null && !(id.getAuthority() instanceof NonMarshalledAuthority)) continue;
                System.arraycopy(copy, i + 1, copy, i, --count - i);
            }
            identifiers = count != 0 ? UnmodifiableArrayList.wrap(copy, 0, count) : null;
        }
        return identifiers;
    }

    public static Collection<? extends Identifier> setMarshallables(Collection<Identifier> identifiers, Collection<? extends Identifier> newValues) {
        int remaining;
        if (identifiers == null || (remaining = identifiers.size()) == 0) {
            return newValues;
        }
        ArrayList<Identifier> toPreserve = null;
        for (Identifier id : identifiers) {
            if (id != null && id.getAuthority() instanceof NonMarshalledAuthority) {
                if (toPreserve == null) {
                    toPreserve = new ArrayList<Identifier>(remaining);
                }
                toPreserve.add(id);
            }
            --remaining;
        }
        if (toPreserve == null) {
            return newValues;
        }
        IdentityHashMap<Citation, Identifier> authorities = new IdentityHashMap<Citation, Identifier>(4);
        ArrayList<Identifier> merged = new ArrayList<Identifier>(newValues.size());
        for (Identifier identifier : newValues) {
            Citation authority;
            merged.add(identifier);
            if (identifier == null || !((authority = identifier.getAuthority()) instanceof NonMarshalledAuthority)) continue;
            authorities.put(authority, identifier);
        }
        for (Identifier identifier : toPreserve) {
            if (authorities.containsKey(identifier.getAuthority())) continue;
            merged.add(identifier);
        }
        switch (merged.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList((Identifier)merged.get(0));
            }
        }
        return Containers.unmodifiableList(CollectionsExt.toArray(merged, Identifier.class));
    }

    @Override
    protected Object readResolve() throws ObjectStreamException {
        IdentifierSpace<Object> candidate;
        String name = this.getName();
        int code = 0;
        do {
            switch (code++) {
                case 0: {
                    candidate = IdentifierSpace.ID;
                    break;
                }
                case 1: {
                    candidate = IdentifierSpace.UUID;
                    break;
                }
                case 2: {
                    candidate = IdentifierSpace.HREF;
                    break;
                }
                case 3: {
                    candidate = IdentifierSpace.XLINK;
                    break;
                }
                default: {
                    return super.readResolve();
                }
            }
        } while (!((NonMarshalledAuthority)candidate).getName().equals(name));
        return candidate;
    }
}

