/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.operation.TransformException;

public abstract class GeometryTransform {
    private final GeometryFactory geometryFactory;
    protected final CoordinateSequenceFactory coordinateFactory;

    protected GeometryTransform(GeometryFactory factory) {
        this.geometryFactory = factory;
        this.coordinateFactory = factory.getCoordinateSequenceFactory();
    }

    public Geometry transform(Geometry geom) throws TransformException {
        if (geom instanceof Point) {
            return this.transform((Point)geom);
        }
        if (geom instanceof MultiPoint) {
            return this.transform((MultiPoint)geom);
        }
        if (geom instanceof LinearRing) {
            return this.transform((LinearRing)geom);
        }
        if (geom instanceof LineString) {
            return this.transform((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return this.transform((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.transform((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return this.transform((MultiPolygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            return this.transform((GeometryCollection)geom);
        }
        throw new IllegalArgumentException(Errors.format((short)163, Classes.getClass(geom)));
    }

    public Point transform(Point geom) throws TransformException {
        CoordinateSequence coord = geom.getCoordinateSequence();
        return this.geometryFactory.createPoint(this.transform(coord, 1));
    }

    public MultiPoint transform(MultiPoint geom) throws TransformException {
        Point[] subs = new Point[geom.getNumGeometries()];
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = this.transform((Point)geom.getGeometryN(i));
        }
        return this.geometryFactory.createMultiPoint(subs);
    }

    public LineString transform(LineString geom) throws TransformException {
        CoordinateSequence seq = this.transform(geom.getCoordinateSequence(), 2);
        return this.geometryFactory.createLineString(seq);
    }

    public MultiLineString transform(MultiLineString geom) throws TransformException {
        LineString[] subs = new LineString[geom.getNumGeometries()];
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = this.transform((LineString)geom.getGeometryN(i));
        }
        return this.geometryFactory.createMultiLineString(subs);
    }

    public LinearRing transform(LinearRing geom) throws TransformException {
        CoordinateSequence seq = this.transform(geom.getCoordinateSequence(), 4);
        return this.geometryFactory.createLinearRing(seq);
    }

    public Polygon transform(Polygon geom) throws TransformException {
        LinearRing exterior = this.transform((LinearRing)geom.getExteriorRing());
        LinearRing[] holes = new LinearRing[geom.getNumInteriorRing()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = this.transform((LinearRing)geom.getInteriorRingN(i));
        }
        return this.geometryFactory.createPolygon(exterior, holes);
    }

    public MultiPolygon transform(MultiPolygon geom) throws TransformException {
        Polygon[] subs = new Polygon[geom.getNumGeometries()];
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = this.transform((Polygon)geom.getGeometryN(i));
        }
        return this.geometryFactory.createMultiPolygon(subs);
    }

    public GeometryCollection transform(GeometryCollection geom) throws TransformException {
        Geometry[] subs = new Geometry[geom.getNumGeometries()];
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = this.transform(geom.getGeometryN(i));
        }
        return this.geometryFactory.createGeometryCollection(subs);
    }

    protected abstract CoordinateSequence transform(CoordinateSequence var1, int var2) throws TransformException;
}

