/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.util.Static;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.util.GenericName;

public final class FeatureUtilities
extends Static {
    public static final ParameterDescriptorGroup LINK_PARAMS = FeatureUtilities.parameters("Link", new ParameterDescriptor[0]);

    private FeatureUtilities() {
    }

    public static ParameterDescriptorGroup parameters(String name, ParameterDescriptor<?> ... parameters) {
        HashMap<String, String> properties = new HashMap<String, String>(4);
        properties.put("name", name);
        properties.put("authority", (String)Citations.SIS);
        return new DefaultParameterDescriptorGroup(properties, 1, 1, new GeneralParameterDescriptor[0]);
    }

    static String linkOf(AbstractIdentifiedType property) {
        AbstractOperation op;
        if (property instanceof AbstractOperation && (op = (AbstractOperation)property).getParameters() == LINK_PARAMS) {
            return CollectionsExt.first(op.getDependencies());
        }
        return null;
    }

    public static String[] getNames(Collection<? extends AbstractIdentifiedType> properties) {
        if (properties == null) {
            return null;
        }
        String[] names = new String[properties.size()];
        Iterator<? extends AbstractIdentifiedType> it = properties.iterator();
        for (int i = 0; i < names.length; ++i) {
            GenericName name;
            AbstractIdentifiedType property = it.next();
            if (property == null || (name = property.getName()) == null) continue;
            names[i] = name.toString();
        }
        if (it.hasNext()) {
            throw new ConcurrentModificationException();
        }
        return names;
    }
}

