/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.OperatorCentroid2D;
import com.esri.core.geometry.OperatorExportToWkt;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import java.util.Iterator;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;

final class ESRI
extends Geometries<Geometry> {
    ESRI() {
        super(GeometryLibrary.ESRI, Geometry.class, Point.class, Polyline.class, Polygon.class);
    }

    @Override
    final String tryGetLabel(Object geometry) {
        return geometry instanceof Geometry ? Classes.getShortClassName(geometry) : null;
    }

    @Override
    final GeneralEnvelope tryGetEnvelope(Object geometry) {
        if (geometry instanceof Geometry) {
            Envelope2D bounds = new Envelope2D();
            ((Geometry)geometry).queryEnvelope2D(bounds);
            if (!bounds.isEmpty()) {
                GeneralEnvelope env = new GeneralEnvelope(2);
                env.setRange(0, bounds.xmin, bounds.xmax);
                env.setRange(1, bounds.ymin, bounds.ymax);
                return env;
            }
        }
        return null;
    }

    @Override
    final double[] tryGetCoordinate(Object point) {
        if (point instanceof Point) {
            double[] coord;
            Point pt = (Point)point;
            double z = pt.getZ();
            if (Double.isNaN(z)) {
                coord = new double[2];
            } else {
                coord = new double[3];
                coord[2] = z;
            }
            coord[1] = pt.getY();
            coord[0] = pt.getX();
            return coord;
        }
        if (point instanceof Point2D) {
            Point2D pt = (Point2D)point;
            return new double[]{pt.x, pt.y};
        }
        if (point instanceof Point3D) {
            Point3D pt = (Point3D)point;
            return new double[]{pt.x, pt.y, pt.z};
        }
        return null;
    }

    @Override
    final Object tryGetCentroid(Object geometry) {
        if (geometry instanceof Geometry) {
            return OperatorCentroid2D.local().execute((Geometry)geometry, null);
        }
        return null;
    }

    @Override
    public Object createPoint(double x, double y) {
        return new Point(x, y, Double.NaN);
    }

    @Override
    public Geometry createPolyline(int dimension, Vector ... coordinates) {
        if (dimension != 2) {
            throw new UnsupportedOperationException(ESRI.unsupported(dimension));
        }
        boolean lineTo = false;
        Polyline path = new Polyline();
        for (Vector v : coordinates) {
            if (v == null) continue;
            int size = v.size();
            int i = 0;
            while (i < size) {
                double x = v.doubleValue(i++);
                double y = v.doubleValue(i++);
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    lineTo = false;
                    continue;
                }
                if (lineTo) {
                    path.lineTo(x, y);
                    continue;
                }
                path.startPath(x, y);
                lineTo = true;
            }
        }
        return path;
    }

    @Override
    final Geometry tryMergePolylines(Object next, Iterator<?> polylines) {
        if (!(next instanceof MultiPath) && !(next instanceof Point)) {
            return null;
        }
        Polyline path = new Polyline();
        boolean lineTo = false;
        block0: while (true) {
            if (next instanceof Point) {
                Point pt = (Point)next;
                if (pt.isEmpty()) {
                    lineTo = false;
                } else {
                    double x = ((Point)next).getX();
                    double y = ((Point)next).getY();
                    if (lineTo) {
                        path.lineTo(x, y);
                    } else {
                        path.startPath(x, y);
                        lineTo = true;
                    }
                }
            } else {
                path.add((MultiPath)next, false);
                lineTo = false;
            }
            while (polylines.hasNext()) {
                next = polylines.next();
                if (next == null) continue;
                continue block0;
            }
            break;
        }
        return path;
    }

    @Override
    public Object parseWKT(String wkt) {
        return OperatorImportFromWkt.local().execute(0, Geometry.Type.Unknown, wkt, null);
    }

    @Override
    final String tryFormatWKT(Object geometry, double flatness) {
        if (geometry instanceof Geometry) {
            return OperatorExportToWkt.local().execute(0, (Geometry)geometry, null);
        }
        return null;
    }
}

