/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.earth.netcdf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.netcdf.AttributeNames;

public final class GCOM_W
extends Convention {
    private static final Pattern SENTINEL_VALUE = Pattern.compile(".*\\bGCOM-W1\\b.*");
    private static final Map<String, String> ATTRIBUTES;
    private static final String[] AXES;
    private static final short NO_DATA = Short.MIN_VALUE;

    @Override
    protected boolean isApplicableTo(Decoder decoder) {
        String s = decoder.stringValue("PlatformShortName");
        return s != null && SENTINEL_VALUE.matcher(s).matches();
    }

    @Override
    public String mapAttributeName(String name) {
        return ATTRIBUTES.getOrDefault(name, name);
    }

    @Override
    public VariableRole roleOf(Variable variable) {
        VariableRole role = super.roleOf(variable);
        if (role == VariableRole.COVERAGE) {
            String name = variable.getName();
            for (String c : AXES) {
                if (!name.regionMatches(true, 0, c, 0, c.length())) continue;
                role = VariableRole.AXIS;
                break;
            }
        }
        return role;
    }

    @Override
    public Set<Linearizer> linearizers(Decoder decoder) {
        return Collections.singleton(Linearizer.GROUND_TRACK);
    }

    @Override
    public Map<Number, Object> nodataValues(Variable data) {
        Map<Number, Object> pads = super.nodataValues(data);
        if (pads.isEmpty() && this.roleOf(data) == VariableRole.COVERAGE) {
            pads.put((short)Short.MIN_VALUE, 3);
        }
        return pads;
    }

    @Override
    public TransferFunction transferFunction(Variable data) {
        TransferFunction tr = super.transferFunction(data);
        if (tr.isIdentity()) {
            double slope = data.getAttributeAsNumber("SCALE FACTOR");
            double offset = data.getAttributeAsNumber("OFFSET");
            if (Double.isFinite(slope)) {
                tr.setScale(slope);
            }
            if (Double.isFinite(offset)) {
                tr.setOffset(offset);
            }
        }
        return tr;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("title", "ProductName");
        m.put("product_version", "ProductVersion");
        m.put(AttributeNames.IDENTIFIER.TEXT, "GranuleID");
        m.put("date_created", "ProductionDateTime");
        m.put(AttributeNames.TIME.MINIMUM, "ObservationStartDateTime");
        m.put(AttributeNames.TIME.MAXIMUM, "ObservationEndDateTime");
        m.put(AttributeNames.CREATOR.INSTITUTION, "ProcessingCenter");
        m.put("summary", "GeophysicalName");
        m.put(AttributeNames.PLATFORM.TEXT, "PlatformShortName");
        m.put(AttributeNames.INSTRUMENT.TEXT, "SensorShortName");
        m.put("source", "InputFileName");
        ATTRIBUTES = m;
        AXES = new String[]{"Latitude", "Longitude"};
    }
}

