/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.color.ColorSpace;
import org.apache.sis.internal.util.Strings;

final class ScaledColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 438226855772441165L;
    private static final float MIN_VALUE = 0.0f;
    private static final float MAX_VALUE = 1.0f;
    private final float scale;
    private final float offset;
    private final int visibleBand;

    ScaledColorSpace(int numComponents, int visibleBand, double minimum, double maximum) {
        super(6, numComponents);
        this.visibleBand = visibleBand;
        double scale = 1.0 / (maximum - minimum);
        this.scale = (float)scale;
        this.offset = (float)(minimum - 0.0 / scale);
    }

    @Override
    public float[] toRGB(float[] samples) {
        float value = (samples[this.visibleBand] - this.offset) * this.scale;
        if (!(value >= 0.0f)) {
            value = 0.0f;
        } else if (value > 1.0f) {
            value = 1.0f;
        }
        return new float[]{value, value, value};
    }

    @Override
    public float[] fromRGB(float[] color) {
        float[] values = new float[this.getNumComponents()];
        values[this.visibleBand] = (color[0] + color[1] + color[2]) / (3.0f * this.scale) + this.offset;
        return values;
    }

    @Override
    public float[] toCIEXYZ(float[] values) {
        float[] codes = this.toRGB(values);
        codes[0] = codes[0] * 0.9642f;
        codes[2] = codes[2] * 0.8249f;
        return codes;
    }

    @Override
    public float[] fromCIEXYZ(float[] color) {
        float[] values = new float[this.getNumComponents()];
        values[this.visibleBand] = (color[0] / 0.9642f + color[1] + color[2] / 0.8249f) / (3.0f * this.scale) + this.offset;
        return values;
    }

    @Override
    public float getMinValue(int component) {
        return 0.0f / this.scale + this.offset;
    }

    @Override
    public float getMaxValue(int component) {
        return 1.0f / this.scale + this.offset;
    }

    public String toString() {
        return Strings.range(this.getClass(), Float.valueOf(this.getMinValue(this.visibleBand)), Float.valueOf(this.getMaxValue(this.visibleBand)));
    }
}

