/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

final class MultiBandsIndexColorModel
extends IndexColorModel {
    final int numBands;
    final int visibleBand;

    public MultiBandsIndexColorModel(int bits, int size, int[] cmap, int start, boolean hasAlpha, int transparent, int transferType, int numBands, int visibleBand) {
        super(bits, size, cmap, start, hasAlpha, transparent, transferType);
        this.numBands = numBands;
        this.visibleBand = visibleBand;
    }

    @Override
    public Object getDataElements(int RGB, Object pixel) {
        if (pixel == null) {
            switch (this.transferType) {
                case 1: 
                case 2: {
                    pixel = new short[this.numBands];
                    break;
                }
                case 0: {
                    pixel = new byte[this.numBands];
                    break;
                }
                case 3: {
                    pixel = new int[this.numBands];
                }
            }
        }
        pixel = super.getDataElements(RGB, pixel);
        switch (this.transferType) {
            case 0: {
                byte[] array = (byte[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            case 1: 
            case 2: {
                short[] array = (short[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            case 3: {
                int[] array = (int[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
        }
        return pixel;
    }

    private int pixel(Object inData) {
        switch (this.transferType) {
            case 0: {
                return Byte.toUnsignedInt(((byte[])inData)[this.visibleBand]);
            }
            case 1: {
                return Short.toUnsignedInt(((short[])inData)[this.visibleBand]);
            }
            case 2: {
                return ((short[])inData)[this.visibleBand];
            }
            case 3: {
                return ((int[])inData)[this.visibleBand];
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        return this.getComponents(this.pixel(components), components, offset);
    }

    @Override
    public int getRed(Object inData) {
        return this.getRed(this.pixel(inData));
    }

    @Override
    public int getGreen(Object inData) {
        return this.getGreen(this.pixel(inData));
    }

    @Override
    public int getBlue(Object inData) {
        return this.getBlue(this.pixel(inData));
    }

    @Override
    public int getAlpha(Object inData) {
        return this.getAlpha(this.pixel(inData));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int width, int height) {
        return Raster.createBandedRaster(this.transferType, width, height, this.numBands, null);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int width, int height) {
        return new BandedSampleModel(this.transferType, width, height, this.numBands);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm instanceof ComponentSampleModel && sm.getTransferType() == this.transferType && sm.getNumBands() == this.numBands && 1 << sm.getSampleSize(this.visibleBand) >= this.getMapSize();
    }
}

