/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.internal.coverage.MultiBandsIndexColorModel;

final class ColorModelPatch<T extends ColorModel> {
    final T cm;

    ColorModelPatch(T cm) {
        this.cm = cm;
    }

    private static boolean equals(ColorModel cm1, ColorModel cm2) {
        if (cm1 == cm2) {
            return true;
        }
        if (cm1 != null && cm1.equals(cm2) && cm1.getClass().equals(cm2.getClass()) && cm1.getTransferType() == cm2.getTransferType() && Objects.equals(cm1.getColorSpace(), cm2.getColorSpace())) {
            if (cm1 instanceof IndexColorModel) {
                IndexColorModel icm1 = (IndexColorModel)cm1;
                IndexColorModel icm2 = (IndexColorModel)cm2;
                int size = icm1.getMapSize();
                if (icm2.getMapSize() == size && icm1.getTransparentPixel() == icm2.getTransparentPixel() && Objects.equals(icm1.getValidPixels(), icm2.getValidPixels())) {
                    for (int i = 0; i < size; ++i) {
                        if (icm1.getRGB(i) == icm2.getRGB(i)) continue;
                        return false;
                    }
                }
                if (cm1 instanceof MultiBandsIndexColorModel) {
                    MultiBandsIndexColorModel micm1 = (MultiBandsIndexColorModel)cm1;
                    MultiBandsIndexColorModel micm2 = (MultiBandsIndexColorModel)cm2;
                    if (micm1.numBands != micm2.numBands || micm1.visibleBand != micm2.visibleBand) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof ColorModelPatch && ColorModelPatch.equals(this.cm, ((ColorModelPatch)object).cm);
    }

    public int hashCode() {
        int code = ((ColorModel)this.cm).hashCode() ^ this.cm.getClass().hashCode();
        if (this.cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)this.cm;
            int[] ARGB = new int[icm.getMapSize()];
            icm.getRGBs(ARGB);
            code ^= Arrays.hashCode(ARGB);
        }
        return code;
    }
}

