/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.internal.coverage.ColorModelPatch;
import org.apache.sis.internal.coverage.MultiBandsIndexColorModel;
import org.apache.sis.internal.coverage.ScaledColorSpace;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.collection.WeakValueHashMap;

public final class ColorModelFactory {
    public static final Function<Category, Color[]> GRAYSCALE = category -> {
        Color[] colorArray;
        if (category.isQuantitative()) {
            Color[] colorArray2 = new Color[2];
            colorArray2[0] = Color.BLACK;
            colorArray = colorArray2;
            colorArray2[1] = Color.WHITE;
        } else {
            colorArray = null;
        }
        return colorArray;
    };
    private static final WeakHashSet<ColorModelPatch> CACHE = new WeakHashSet<ColorModelPatch>(ColorModelPatch.class);
    private static final Map<ColorModelFactory, ColorModel> PIECEWISES = new WeakValueHashMap<ColorModelFactory, ColorModel>(ColorModelFactory.class);
    private static final Comparator<Map.Entry<NumberRange<?>, Color[]>> RANGE_COMPARATOR = (r1, r2) -> Double.compare(((NumberRange)r1.getKey()).getMinDouble(true), ((NumberRange)r2.getKey()).getMinDouble(true));
    private final double minimum;
    private final double maximum;
    private final int[] pieceStarts;
    private final int[][] ARGB;
    private final int visibleBand;
    private final int numBands;
    private final int type;

    private ColorModelFactory(Map<? extends NumberRange<?>, ? extends Color[]> categories, int visibleBand, int numBands, int type) {
        this.visibleBand = visibleBand;
        this.numBands = numBands;
        this.type = type;
        Map.Entry[] entries = categories.entrySet().toArray(new Map.Entry[categories.size()]);
        Arrays.sort(entries, RANGE_COMPARATOR);
        int count = 0;
        int[] starts = new int[entries.length + 1];
        Object codes = new int[entries.length][];
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        for (Map.Entry entry : entries) {
            int before;
            int upper;
            int lower;
            NumberRange range = (NumberRange)entry.getKey();
            double min = range.getMinDouble(true);
            double max = range.getMaxDouble(false);
            if (min < minimum) {
                minimum = min;
            }
            if (max > maximum) {
                maximum = max;
            }
            if ((lower = Math.round((float)min)) >= (upper = Math.round((float)max))) continue;
            if (lower < 0 || upper > 65536) {
                starts = ArraysExt.EMPTY_INT;
                codes = null;
                count = 0;
                continue;
            }
            if (codes == null) continue;
            if (count != 0 && (before = starts[count]) != lower && before <= lower) {
                codes = (int[][])Arrays.copyOf(codes, ((int[][])codes).length + 1);
                starts = Arrays.copyOf(starts, starts.length + 1);
                codes[count++] = ArraysExt.EMPTY_INT;
            }
            codes[count] = ColorModelFactory.toARGB((Color[])entry.getValue());
            starts[count] = lower;
            starts[++count] = upper;
        }
        if (minimum >= maximum) {
            minimum = 0.0;
            maximum = 1.0;
        }
        if (starts.length != 0) {
            starts = ArraysExt.resize(starts, count + 1);
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.pieceStarts = starts;
        this.ARGB = codes;
    }

    private ColorModel createColorModel() {
        int[] colorMap;
        if (this.type != 0 && this.type != 1) {
            ColorSpace colors = ColorModelFactory.createColorSpace(this.numBands, this.visibleBand, this.minimum, this.maximum);
            return ColorModelFactory.unique(new ComponentColorModel(colors, false, false, 1, this.type));
        }
        int categoryCount = this.pieceStarts.length - 1;
        if (this.numBands == 1 && categoryCount <= 0) {
            ColorSpace cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{DataBuffer.getDataTypeSize(this.type)};
            return ColorModelFactory.unique(new ComponentColorModel(cs, nBits, false, true, 1, this.type));
        }
        int transparent = -1;
        if (categoryCount <= 0) {
            colorMap = ArraysExt.range(0, 256);
        } else {
            colorMap = new int[this.pieceStarts[categoryCount]];
            for (int i = 0; i < categoryCount; ++i) {
                int[] colors = this.ARGB[i];
                int lower = this.pieceStarts[i];
                int upper = this.pieceStarts[i + 1];
                if (transparent < 0 && colors.length == 0) {
                    transparent = lower;
                }
                ColorModelFactory.expand(colors, colorMap, lower, upper);
            }
        }
        return ColorModelFactory.createIndexColorModel(colorMap, this.numBands, this.visibleBand, transparent);
    }

    public int hashCode() {
        int categoryCount = this.pieceStarts.length - 1;
        int code = 962745549 + (this.numBands * 31 + this.visibleBand) * 31 + categoryCount;
        for (int i = 0; i < categoryCount; ++i) {
            code += Arrays.hashCode(this.ARGB[i]);
        }
        return code;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ColorModelFactory) {
            ColorModelFactory that = (ColorModelFactory)other;
            return this.type == that.type && this.numBands == that.numBands && this.visibleBand == that.visibleBand && this.minimum == that.minimum && this.maximum == that.maximum && Arrays.equals(this.pieceStarts, that.pieceStarts) && Arrays.deepEquals((Object[])this.ARGB, (Object[])that.ARGB);
        }
        return false;
    }

    public static ColorModel createColorModel(SampleDimension[] bands, int visibleBand, int type, Function<Category, Color[]> colors) {
        ArgumentChecks.ensureNonNull("bands", bands);
        ArgumentChecks.ensureNonNull("colors", colors);
        LinkedHashMap ranges = new LinkedHashMap();
        for (Category category : bands[visibleBand].getCategories()) {
            ranges.put(category.getSampleRange(), colors.apply(category));
        }
        return ColorModelFactory.createColorModel(ranges, visibleBand, bands.length, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorModel createColorModel(Map<? extends NumberRange<?>, ? extends Color[]> categories, int visibleBand, int numBands, int type) {
        ArgumentChecks.ensureNonNull("categories", categories);
        ArgumentChecks.ensureBetween("visibleBand", 0, numBands - 1, visibleBand);
        ColorModelFactory key = new ColorModelFactory(categories, visibleBand, numBands, type);
        Map<ColorModelFactory, ColorModel> map = PIECEWISES;
        synchronized (map) {
            ColorModel model = PIECEWISES.get(key);
            if (model == null) {
                model = key.createColorModel();
                PIECEWISES.put(key, model);
            }
            return model;
        }
    }

    public static IndexColorModel createIndexColorModel(int[] ARGB, int numBands, int visibleBand, int transparent) {
        int length = ARGB.length;
        int bits = ColorModelFactory.getBitCount(length);
        int type = ColorModelFactory.getTransferType(length);
        IndexColorModel cm = numBands == 1 ? new IndexColorModel(bits, length, ARGB, 0, true, transparent, type) : new MultiBandsIndexColorModel(bits, length, ARGB, 0, true, transparent, type, numBands, visibleBand);
        return ColorModelFactory.unique(cm);
    }

    public static ColorSpace createColorSpace(int numComponents, int visibleBand, double minimum, double maximum) {
        if (numComponents == 1 && minimum == 0.0 && maximum == 1.0) {
            return ColorSpace.getInstance(1003);
        }
        return new ScaledColorSpace(numComponents, visibleBand, minimum, maximum);
    }

    public static <T extends ColorModel> T unique(T cm) {
        ColorModelPatch<T> c = new ColorModelPatch<T>(cm);
        c = CACHE.unique(c);
        return c.cm;
    }

    private static int getTransferType(int mapSize) {
        return mapSize <= 256 ? 0 : 1;
    }

    public static int getBitCount(int mapSize) {
        int count = 32 - Integer.numberOfLeadingZeros(mapSize - 1);
        assert (1 << count >= mapSize) : mapSize;
        assert (1 << count - 1 < mapSize) : mapSize;
        return Math.max(1, count);
    }

    private static int[] toARGB(Color[] colors) {
        if (colors != null) {
            int combined = 0;
            int[] ARGB = new int[colors.length];
            for (int i = 0; i < ARGB.length; ++i) {
                Color color = colors[i];
                if (color == null) continue;
                int c = color.getRGB();
                combined |= c;
                ARGB[i] = c;
            }
            if ((combined & 0xFF000000) != 0) {
                return ARGB;
            }
        }
        return ArraysExt.EMPTY_INT;
    }

    public static void expand(int[] colors, int[] ARGB, int lower, int upper) {
        switch (colors.length) {
            case 1: {
                Arrays.fill(ARGB, lower, upper, colors[0]);
            }
            case 0: {
                return;
            }
        }
        switch (upper - lower) {
            case 1: {
                ARGB[lower] = colors[0];
            }
            case 0: {
                return;
            }
        }
        double scale = (double)(colors.length - 1) / (double)(upper - lower - 1);
        int maxBase = colors.length - 2;
        float index = 0.0f;
        int base = 0;
        int i = lower;
        while (true) {
            int C0 = colors[base];
            int C1 = colors[base + 1];
            int A0 = C0 >>> 24 & 0xFF;
            int A1 = (C1 >>> 24 & 0xFF) - A0;
            int R0 = C0 >>> 16 & 0xFF;
            int R1 = (C1 >>> 16 & 0xFF) - R0;
            int G0 = C0 >>> 8 & 0xFF;
            int G1 = (C1 >>> 8 & 0xFF) - G0;
            int B0 = C0 & 0xFF;
            int B1 = (C1 & 0xFF) - B0;
            int oldBase = base;
            do {
                float delta = index - (float)base;
                ARGB[i] = ColorModelFactory.roundByte((float)A0 + delta * (float)A1) << 24 | ColorModelFactory.roundByte((float)R0 + delta * (float)R1) << 16 | ColorModelFactory.roundByte((float)G0 + delta * (float)G1) << 8 | ColorModelFactory.roundByte((float)B0 + delta * (float)B1);
                if (++i != upper) continue;
                return;
            } while ((base = Math.min(maxBase, (int)((index = (float)((double)(i - lower) * scale)) + Math.ulp(index)))) == oldBase);
        }
    }

    private static int roundByte(float value) {
        return Math.min(Math.max(Math.round(value), 0), 255);
    }
}

