/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.util.Collection;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.internal.coverage.ConvertedGridCoverage;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class BufferedGridCoverage
extends GridCoverage {
    protected final DataBuffer data;
    private GridCoverage converted;

    public BufferedGridCoverage(GridGeometry grid, Collection<? extends SampleDimension> bands, DataBuffer data) {
        super(grid, bands);
        this.data = data;
        ArgumentChecks.ensureNonNull("data", data);
    }

    public BufferedGridCoverage(GridGeometry grid, Collection<? extends SampleDimension> bands, int dataType) {
        super(grid, bands);
        long nbSamples = bands.size();
        GridExtent extent = grid.getExtent();
        int i = grid.getDimension();
        while (--i >= 0) {
            nbSamples = Math.multiplyExact(nbSamples, extent.getSize(i));
        }
        int n = Math.toIntExact(nbSamples);
        switch (dataType) {
            case 0: {
                this.data = new DataBufferByte(n);
                break;
            }
            case 2: {
                this.data = new DataBufferShort(n);
                break;
            }
            case 1: {
                this.data = new DataBufferUShort(n);
                break;
            }
            case 3: {
                this.data = new DataBufferInt(n);
                break;
            }
            case 4: {
                this.data = new DataBufferFloat(n);
                break;
            }
            case 5: {
                this.data = new DataBufferDouble(n);
                break;
            }
            default: {
                throw new IllegalArgumentException(Errors.format((short)149, dataType));
            }
        }
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        try {
            ImageRenderer renderer = new ImageRenderer(this, sliceExtent);
            renderer.setData(this.data);
            return renderer.image();
        }
        catch (RasterFormatException | ArithmeticException | IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCoverage forConvertedValues(boolean converted) {
        if (converted) {
            BufferedGridCoverage bufferedGridCoverage = this;
            synchronized (bufferedGridCoverage) {
                if (this.converted == null) {
                    this.converted = BufferedGridCoverage.convert(this);
                }
                return this.converted;
            }
        }
        return this;
    }

    public static GridCoverage convert(GridCoverage packed) {
        return ConvertedGridCoverage.create(packed);
    }
}

