/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.sis.index.tree.NodeType;
import org.apache.sis.index.tree.QuadTree;
import org.apache.sis.index.tree.QuadTreeData;
import org.apache.sis.index.tree.QuadTreeNode;
import org.apache.sis.index.tree.Quadrant;

public final class QuadTreeWriter {
    private QuadTreeWriter() {
    }

    public static void writeTreeToFile(QuadTree tree, String directory) throws IOException {
        QuadTreeWriter.createIdxDir(directory);
        QuadTreeWriter.writeTreeConfigsToFile(tree, directory);
        QuadTreeWriter.writeNodeToFile(tree.getRoot(), directory);
    }

    private static void createIdxDir(String directory) {
        File dir = new File(directory);
        if (!dir.exists()) {
            System.out.println("[INFO] Creating qtree idx dir: [" + directory + "]");
            new File(directory).mkdirs();
        }
    }

    private static void writeTreeConfigsToFile(QuadTree tree, String directory) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(directory + "tree_config.txt"));){
            writer.write("capacity;" + tree.getCapacity() + ";depth;" + tree.getDepth());
            writer.newLine();
            writer.close();
        }
    }

    private static void writeChildrenToFile(QuadTreeNode node, Quadrant quadrant, BufferedWriter writer, String directory, boolean checkIfParent) throws IOException {
        if (checkIfParent) {
            if (node.getChild(quadrant) != null && node.getChild(quadrant).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(node.getChild(quadrant), directory);
            }
        } else if (node.getChild(quadrant) != null) {
            writer.write(QuadTreeWriter.getQuadTreeDataString(quadrant, node.getChild(quadrant)));
            writer.newLine();
        }
    }

    private static void writeNodeToFile(QuadTreeNode node, String directory) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(directory + "node_" + node.getId() + ".txt"));){
            if (node.getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeChildrenToFile(node, Quadrant.NW, writer, directory, false);
                QuadTreeWriter.writeChildrenToFile(node, Quadrant.NE, writer, directory, false);
                QuadTreeWriter.writeChildrenToFile(node, Quadrant.SW, writer, directory, false);
                QuadTreeWriter.writeChildrenToFile(node, Quadrant.SE, writer, directory, false);
            }
        }
        if (node.getNodeType() == NodeType.GRAY) {
            QuadTreeWriter.writeChildrenToFile(node, Quadrant.NW, null, directory, true);
            QuadTreeWriter.writeChildrenToFile(node, Quadrant.NE, null, directory, true);
            QuadTreeWriter.writeChildrenToFile(node, Quadrant.SW, null, directory, true);
            QuadTreeWriter.writeChildrenToFile(node, Quadrant.SE, null, directory, true);
        }
    }

    private static String getQuadTreeDataString(Quadrant quadrant, QuadTreeNode node) {
        StringBuilder str = new StringBuilder();
        str.append(quadrant.index());
        str.append(':');
        str.append(node.getNodeType().toString());
        str.append(':');
        str.append(node.getId());
        str.append(':');
        str.append(node.getCapacity());
        str.append(':');
        QuadTreeData[] data = node.getData();
        for (int i = 0; i < node.getCount(); ++i) {
            str.append(data[i].getLatLon().y);
            str.append(';');
            str.append(data[i].getLatLon().x);
            str.append(';');
            str.append(data[i].getFileName());
            str.append(':');
        }
        return str.substring(0, str.length() - 1);
    }
}

