/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.io.Closeable;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.internal.feature.Resources;

public abstract class WritablePixelIterator
extends PixelIterator
implements Closeable {
    final WritableRenderedImage destination;
    WritableRaster destRaster;

    WritablePixelIterator(Raster input, WritableRaster output, Rectangle subArea, Dimension window) {
        super(input, subArea, window);
        this.destRaster = output;
        this.destination = null;
        if (output != null) {
            if (!input.getSampleModel().equals(output.getSampleModel())) {
                throw new IllegalArgumentException(Resources.format((short)41));
            }
            if (!input.getBounds().equals(output.getBounds())) {
                throw new IllegalArgumentException(Resources.format((short)40));
            }
        }
    }

    WritablePixelIterator(RenderedImage input, WritableRenderedImage output, Rectangle subArea, Dimension window) {
        super(input, subArea, window);
        this.destRaster = null;
        this.destination = output;
        if (output != null) {
            if (!input.getSampleModel().equals(output.getSampleModel())) {
                throw new IllegalArgumentException(Resources.format((short)41));
            }
            if (input.getMinX() != output.getMinX() || input.getMinY() != output.getMinY() || input.getWidth() != output.getWidth() || input.getHeight() != output.getHeight()) {
                throw new IllegalArgumentException(Resources.format((short)40));
            }
            if (input.getMinTileX() != output.getMinTileX() || input.getMinTileY() != output.getMinTileY() || input.getTileWidth() != output.getTileWidth() || input.getTileHeight() != output.getTileHeight()) {
                throw new IllegalArgumentException(Resources.format((short)42));
            }
        }
    }

    public static WritablePixelIterator create(WritableRenderedImage data) {
        return new PixelIterator.Builder().createWritable(data);
    }

    @Override
    public boolean isWritable() {
        return this.destination != null || this.destRaster != null;
    }

    public abstract void setSample(int var1, int var2);

    public abstract void setSample(int var1, float var2);

    public abstract void setSample(int var1, double var2);

    public abstract void setPixel(int[] var1);

    public abstract void setPixel(float[] var1);

    public abstract void setPixel(double[] var1);

    @Override
    public abstract void close();
}

