/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.nio.Buffer;
import java.util.Arrays;
import java.util.Optional;
import org.apache.sis.image.DefaultIterator;
import org.apache.sis.image.LinearIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.image.TransferType;
import org.apache.sis.image.WritablePixelIterator;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public abstract class PixelIterator {
    final RenderedImage image;
    Raster currentRaster;
    final int numBands;
    final int lowerX;
    final int lowerY;
    final int upperX;
    final int upperY;
    final int tileWidth;
    final int tileHeight;
    final int tileGridXOffset;
    final int tileGridYOffset;
    final int tileLowerX;
    final int tileLowerY;
    final int tileUpperX;
    final int tileUpperY;
    final int windowWidth;
    final int windowHeight;

    PixelIterator(Raster data, Rectangle subArea, Dimension window) {
        this.image = null;
        this.currentRaster = data;
        this.numBands = data.getNumBands();
        this.tileWidth = data.getWidth();
        this.tileHeight = data.getHeight();
        this.tileGridXOffset = data.getMinX();
        this.tileGridYOffset = data.getMinY();
        this.tileLowerX = 0;
        this.tileLowerY = 0;
        this.tileUpperX = 1;
        this.tileUpperY = 1;
        Rectangle bounds = PixelIterator.intersection(this.tileGridXOffset, this.tileGridYOffset, this.tileWidth, this.tileHeight, subArea, window);
        this.lowerX = bounds.x;
        this.lowerY = bounds.y;
        this.upperX = Math.addExact(this.lowerX, bounds.width);
        this.upperY = Math.addExact(this.lowerY, bounds.height);
        this.windowWidth = window != null ? window.width : 0;
        this.windowHeight = window != null ? window.height : 0;
    }

    PixelIterator(RenderedImage data, Rectangle subArea, Dimension window) {
        this.image = data;
        this.numBands = data.getSampleModel().getNumBands();
        this.tileWidth = data.getTileWidth();
        this.tileHeight = data.getTileHeight();
        this.tileGridXOffset = data.getTileGridXOffset();
        this.tileGridYOffset = data.getTileGridYOffset();
        Rectangle bounds = PixelIterator.intersection(data.getMinX(), data.getMinY(), data.getWidth(), data.getHeight(), subArea, window);
        this.lowerX = bounds.x;
        this.lowerY = bounds.y;
        this.upperX = Math.addExact(this.lowerX, bounds.width);
        this.upperY = Math.addExact(this.lowerY, bounds.height);
        this.tileLowerX = Math.floorDiv(Math.subtractExact(this.lowerX, this.tileGridXOffset), this.tileWidth);
        this.tileLowerY = Math.floorDiv(Math.subtractExact(this.lowerY, this.tileGridYOffset), this.tileHeight);
        this.tileUpperX = Numerics.ceilDiv(Math.subtractExact(this.upperX, this.tileGridXOffset), this.tileWidth);
        this.tileUpperY = Numerics.ceilDiv(Math.subtractExact(this.upperY, this.tileGridYOffset), this.tileHeight);
        this.windowWidth = window != null ? window.width : 0;
        this.windowHeight = window != null ? window.height : 0;
    }

    private static Rectangle intersection(int x, int y, int width, int height, Rectangle subArea, Dimension window) {
        if (window != null) {
            ArgumentChecks.ensureBetween("window.width", 1, width, window.width);
            ArgumentChecks.ensureBetween("window.height", 1, height, window.height);
            width -= window.width - 1;
            height -= window.height - 1;
        }
        Rectangle bounds = new Rectangle(x, y, width, height);
        if (subArea != null) {
            bounds = bounds.intersection(subArea);
            if (bounds.width < 0) {
                bounds.width = 0;
            }
            if (bounds.height < 0) {
                bounds.height = 0;
            }
        }
        return bounds;
    }

    public static PixelIterator create(RenderedImage data) {
        return new Builder().create(data);
    }

    public boolean isWritable() {
        return false;
    }

    public TransferType<?> getTransferType() {
        return TransferType.valueOf(this.image != null ? this.image.getSampleModel().getTransferType() : this.currentRaster.getTransferType());
    }

    public NumberRange<?>[] getSampleRanges() {
        NumberRange<Number> range;
        SampleModel model = this.currentRaster != null ? this.currentRaster.getSampleModel() : this.image.getSampleModel();
        Object[] ranges = new NumberRange[model.getNumBands()];
        if (model instanceof MultiPixelPackedSampleModel) {
            int numBits = ((MultiPixelPackedSampleModel)model).getPixelBitStride();
            range = NumberRange.create(0, true, (1 << numBits) - 1, true);
        } else {
            if (model instanceof SinglePixelPackedSampleModel) {
                int[] masks = ((SinglePixelPackedSampleModel)model).getBitMasks();
                for (int i = 0; i < masks.length; ++i) {
                    int numBits = Integer.bitCount(masks[i]);
                    ranges[i] = NumberRange.create(0, true, (1 << numBits) - 1, true);
                }
                return ranges;
            }
            int type = model.getDataType();
            switch (type) {
                case 0: {
                    range = NumberRange.create((short)0, true, (short)255, true);
                    break;
                }
                case 1: {
                    range = NumberRange.create(0, true, 65535, true);
                    break;
                }
                case 2: {
                    range = NumberRange.create((short)Short.MIN_VALUE, true, (short)Short.MAX_VALUE, true);
                    break;
                }
                case 3: {
                    range = NumberRange.create(Integer.MIN_VALUE, true, Integer.MAX_VALUE, true);
                    break;
                }
                case 4: {
                    range = NumberRange.create(Float.NEGATIVE_INFINITY, false, Float.POSITIVE_INFINITY, false);
                    break;
                }
                case 5: {
                    range = NumberRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false);
                    break;
                }
                default: {
                    throw new IllegalStateException(Errors.format((short)149, type));
                }
            }
        }
        Arrays.fill(ranges, range);
        return ranges;
    }

    abstract Optional<SequenceType> getIterationOrder();

    public int getNumBands() {
        return this.numBands;
    }

    public Rectangle getDomain() {
        return new Rectangle(this.lowerX, this.lowerY, this.upperX - this.lowerX, this.upperY - this.lowerY);
    }

    public abstract Point getPosition();

    public abstract void moveTo(int var1, int var2);

    public abstract boolean next();

    public abstract int getSample(int var1);

    public abstract float getSampleFloat(int var1);

    public abstract double getSampleDouble(int var1);

    public abstract int[] getPixel(int[] var1);

    public abstract float[] getPixel(float[] var1);

    public abstract double[] getPixel(double[] var1);

    public abstract <T extends Buffer> Window<T> createWindow(TransferType<T> var1);

    public abstract void rewind();

    public static abstract class Window<T extends Buffer> {
        public final T values;

        Window(T buffer) {
            this.values = buffer;
        }

        public abstract void update();
    }

    public static class Builder {
        private Rectangle subArea;
        private Dimension window;
        private SequenceType order;

        public Builder setRegionOfInterest(Rectangle subArea) {
            this.subArea = subArea;
            return this;
        }

        public Builder setWindowSize(Dimension window) {
            this.window = window;
            return this;
        }

        final Builder setIteratorOrder(SequenceType order) {
            if (order != null && !order.equals((Object)SequenceType.LINEAR)) {
                throw new IllegalArgumentException(Errors.format((short)163, (Object)order));
            }
            this.order = order;
            return this;
        }

        public PixelIterator create(Raster data) {
            ArgumentChecks.ensureNonNull("data", data);
            if (this.order == SequenceType.LINEAR) {
                return new LinearIterator(data, null, this.subArea, this.window);
            }
            if (this.order != null) {
                throw new IllegalStateException(Errors.format((short)163, (Object)this.order));
            }
            return new DefaultIterator(data, null, this.subArea, this.window);
        }

        public PixelIterator create(RenderedImage data) {
            ArgumentChecks.ensureNonNull("data", data);
            if (this.order == SequenceType.LINEAR) {
                return new LinearIterator(data, null, this.subArea, this.window);
            }
            if (this.order != null) {
                throw new IllegalStateException(Errors.format((short)163, (Object)this.order));
            }
            return new DefaultIterator(data, null, this.subArea, this.window);
        }

        public WritablePixelIterator createWritable(WritableRaster data) {
            ArgumentChecks.ensureNonNull("data", data);
            return this.createWritable(data, data);
        }

        public WritablePixelIterator createWritable(WritableRenderedImage data) {
            ArgumentChecks.ensureNonNull("data", data);
            return this.createWritable(data, data);
        }

        public WritablePixelIterator createWritable(Raster input, WritableRaster output) {
            ArgumentChecks.ensureNonNull("input", input);
            ArgumentChecks.ensureNonNull("output", output);
            if (this.order == SequenceType.LINEAR) {
                return new LinearIterator(input, output, this.subArea, this.window);
            }
            if (this.order != null) {
                throw new IllegalStateException(Errors.format((short)163, (Object)this.order));
            }
            return new DefaultIterator(input, output, this.subArea, this.window);
        }

        public WritablePixelIterator createWritable(RenderedImage input, WritableRenderedImage output) {
            ArgumentChecks.ensureNonNull("input", input);
            ArgumentChecks.ensureNonNull("output", output);
            if (this.order == SequenceType.LINEAR) {
                return new LinearIterator(input, output, this.subArea, this.window);
            }
            if (this.order != null) {
                throw new IllegalStateException(Errors.format((short)163, (Object)this.order));
            }
            return new DefaultIterator(input, output, this.subArea, this.window);
        }
    }
}

