/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.ConcurrentModificationException;
import java.util.Set;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.CurveExtremum;
import org.apache.sis.geometry.EnvelopeReducer;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class Envelopes
extends Static {
    private static final boolean[] CORNERS = new boolean[]{false, false, false, true, true, true, true, false, false, false};

    private Envelopes() {
    }

    public static Envelope compound(Envelope ... components) throws FactoryException {
        ArgumentChecks.ensureNonNull("components", components);
        int sum = 0;
        for (int i = 0; i < components.length; ++i) {
            Envelope env = components[i];
            ArgumentChecks.ensureNonNullElement("components", i, env);
            sum += env.getDimension();
        }
        GeneralEnvelope compound = new GeneralEnvelope(sum);
        CoordinateReferenceSystem[] crsComponents = null;
        int firstAffectedCoordinate = 0;
        for (int i = 0; i < components.length; ++i) {
            Envelope env = components[i];
            int dim = env.getDimension();
            compound.subEnvelope(firstAffectedCoordinate, firstAffectedCoordinate += dim).setEnvelope(env);
            if (i == 0) {
                CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
                if (crs == null) continue;
                crsComponents = new CoordinateReferenceSystem[components.length];
                crsComponents[0] = crs;
                continue;
            }
            if (crsComponents == null || (crsComponents[i] = env.getCoordinateReferenceSystem()) != null) continue;
            crsComponents = null;
        }
        if (firstAffectedCoordinate != sum) {
            throw new ConcurrentModificationException();
        }
        if (crsComponents != null) {
            compound.setCoordinateReferenceSystem(CRS.compound(crsComponents));
        }
        return compound;
    }

    public static GeneralEnvelope union(Envelope ... envelopes) throws TransformException {
        return EnvelopeReducer.UNION.reduce(envelopes);
    }

    public static CoordinateOperation findOperation(Envelope source, Envelope target) throws FactoryException {
        CoordinateReferenceSystem targetCRS;
        CoordinateReferenceSystem sourceCRS;
        if (source != null && target != null && (sourceCRS = source.getCoordinateReferenceSystem()) != null && (targetCRS = target.getCoordinateReferenceSystem()) != null) {
            DefaultGeographicBoundingBox areaOfInterest = null;
            if (sourceCRS != targetCRS) {
                try {
                    ReferencingServices converter = ReferencingServices.getInstance();
                    areaOfInterest = converter.setBounds(source, null, "findOperation");
                    DefaultGeographicBoundingBox targetAOI = converter.setBounds(target, null, "findOperation");
                    if (areaOfInterest == null) {
                        areaOfInterest = targetAOI;
                    } else if (targetAOI != null) {
                        areaOfInterest.add(targetAOI);
                    }
                }
                catch (TransformException e) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.geometry"), Envelopes.class, "findOperation", e);
                }
            }
            return CRS.findOperation(sourceCRS, targetCRS, areaOfInterest);
        }
        return null;
    }

    public static GeneralEnvelope intersect(Envelope ... envelopes) throws TransformException {
        return EnvelopeReducer.INTERSECT.reduce(envelopes);
    }

    static void recoverableException(Class<? extends Static> caller, TransformException exception) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.geometry"), caller, "transform", exception);
    }

    static Matrix derivativeAndTransform(MathTransform transform, double[] srcPts, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        if (transform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)transform).transform(srcPts, 0, dstPts, dstOff, derivate);
        }
        Matrix derivative = derivate ? transform.derivative((DirectPosition)new DirectPositionView.Double(srcPts, 0, transform.getSourceDimensions())) : null;
        transform.transform(srcPts, 0, dstPts, dstOff, 1);
        return derivative;
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException {
        CoordinateReferenceSystem sourceCRS;
        if (envelope != null && targetCRS != null && (sourceCRS = envelope.getCoordinateReferenceSystem()) != targetCRS) {
            if (sourceCRS == null) {
                envelope = new GeneralEnvelope(envelope);
                ((GeneralEnvelope)envelope).setCoordinateReferenceSystem(targetCRS);
            } else {
                CoordinateOperation operation;
                try {
                    operation = CoordinateOperations.factory().createOperation(sourceCRS, targetCRS);
                }
                catch (FactoryException exception) {
                    throw new TransformException(Errors.format((short)16), (Throwable)exception);
                }
                envelope = Envelopes.transform(operation, envelope);
            }
            assert (Utilities.deepEquals(targetCRS, envelope.getCoordinateReferenceSystem(), ComparisonMode.DEBUG));
        }
        return envelope;
    }

    public static GeneralEnvelope transform(MathTransform transform, Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", transform);
        return envelope != null ? Envelopes.transform(transform, envelope, null) : null;
    }

    private static GeneralEnvelope transform(MathTransform transform, Envelope envelope, double[] targetPt) throws TransformException {
        if (transform.isIdentity()) {
            GeneralEnvelope transformed = new GeneralEnvelope(envelope);
            transformed.setCoordinateReferenceSystem(null);
            if (targetPt != null) {
                int i = envelope.getDimension();
                while (--i >= 0) {
                    targetPt[i] = transformed.getMedian(i);
                }
            }
            return transformed;
        }
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        if (envelope.getDimension() != sourceDim) {
            throw new MismatchedDimensionException(Errors.format((short)80, sourceDim, envelope.getDimension()));
        }
        if (sourceDim >= 20) {
            throw new IllegalArgumentException(Errors.format((short)37));
        }
        int pointIndex = 0;
        boolean isDerivativeSupported = true;
        GeneralEnvelope transformed = null;
        Matrix[] derivatives = new Matrix[Math.toIntExact(MathFunctions.pow(3L, sourceDim))];
        double[] coordinates = new double[derivatives.length * targetDim];
        double[] sourcePt = new double[sourceDim];
        int i = sourceDim;
        while (--i >= 0) {
            sourcePt[i] = envelope.getMinimum(i);
        }
        DirectPositionView.Double ordinatesView = new DirectPositionView.Double(coordinates, 0, targetDim);
        block14: while (true) {
            int offset = pointIndex * targetDim;
            try {
                derivatives[pointIndex] = Envelopes.derivativeAndTransform(transform, sourcePt, coordinates, offset, isDerivativeSupported);
            }
            catch (TransformException e) {
                if (!isDerivativeSupported) {
                    throw e;
                }
                isDerivativeSupported = false;
                transform.transform(sourcePt, 0, coordinates, offset, 1);
                Envelopes.recoverableException(Envelopes.class, e);
            }
            if (transformed == null) {
                transformed = new GeneralEnvelope(targetDim);
                for (int i2 = 0; i2 < targetDim; ++i2) {
                    double value = coordinates[offset + i2];
                    transformed.setRange(i2, value, value);
                }
            } else {
                ordinatesView.offset = offset;
                transformed.add(ordinatesView);
            }
            int indexBase3 = ++pointIndex;
            int dim = sourceDim;
            while (--dim >= 0) {
                switch (indexBase3 % 3) {
                    case 0: {
                        sourcePt[dim] = envelope.getMinimum(dim);
                        break;
                    }
                    case 1: {
                        sourcePt[dim] = envelope.getMaximum(dim);
                        continue block14;
                    }
                    case 2: {
                        sourcePt[dim] = envelope.getMedian(dim);
                        continue block14;
                    }
                    default: {
                        throw new AssertionError(indexBase3);
                    }
                }
                indexBase3 /= 3;
            }
            break;
        }
        assert (pointIndex == derivatives.length) : pointIndex;
        DirectPosition temporary = null;
        DirectPositionView.Double sourceView = new DirectPositionView.Double(sourcePt, 0, sourceDim);
        CurveExtremum extremum = new CurveExtremum();
        for (pointIndex = 0; pointIndex < derivatives.length; ++pointIndex) {
            Matrix D1 = derivatives[pointIndex];
            if (D1 == null) continue;
            int indexBase3 = pointIndex;
            int power3 = 1;
            int i3 = sourceDim;
            while (--i3 >= 0) {
                int medianIndex;
                Matrix D2;
                int digitBase3 = indexBase3 % 3;
                if (digitBase3 != 2 && (D2 = derivatives[medianIndex = pointIndex + power3 * (2 - digitBase3)]) != null) {
                    double xmin = envelope.getMinimum(i3);
                    double xmax = envelope.getMaximum(i3);
                    double x2 = envelope.getMedian(i3);
                    double x1 = digitBase3 == 0 ? xmin : xmax;
                    int offset1 = targetDim * pointIndex;
                    int offset2 = targetDim * medianIndex;
                    for (int j = 0; j < targetDim; ++j) {
                        extremum.resolve(x1, coordinates[offset1 + j], D1.getElement(j, i3), x2, coordinates[offset2 + j], D2.getElement(j, i3));
                        boolean isP2 = false;
                        do {
                            double y;
                            double x;
                            double d = x = isP2 ? extremum.ex2 : extremum.ex1;
                            if (!(x > xmin) || !(x < xmax)) continue;
                            double d2 = y = isP2 ? extremum.ey2 : extremum.ey1;
                            if (!(y < transformed.getMinimum(j)) && !(y > transformed.getMaximum(j))) continue;
                            int ib3 = pointIndex;
                            int dim = sourceDim;
                            while (--dim >= 0) {
                                double coordinate;
                                if (dim == i3) {
                                    coordinate = x;
                                } else {
                                    switch (ib3 % 3) {
                                        case 0: {
                                            coordinate = envelope.getMinimum(dim);
                                            break;
                                        }
                                        case 1: {
                                            coordinate = envelope.getMaximum(dim);
                                            break;
                                        }
                                        case 2: {
                                            coordinate = envelope.getMedian(dim);
                                            break;
                                        }
                                        default: {
                                            throw new AssertionError(ib3);
                                        }
                                    }
                                }
                                sourcePt[dim] = coordinate;
                                ib3 /= 3;
                            }
                            temporary = transform.transform((DirectPosition)sourceView, temporary);
                            transformed.add(temporary);
                        } while (isP2 = !isP2);
                    }
                }
                indexBase3 /= 3;
                power3 *= 3;
            }
            derivatives[pointIndex] = null;
        }
        if (targetPt != null) {
            System.arraycopy(coordinates, coordinates.length - targetDim, targetPt, 0, targetDim);
        }
        return transformed;
    }

    public static GeneralEnvelope transform(CoordinateOperation operation, Envelope envelope) throws TransformException {
        long includedBoundsValue;
        CoordinateReferenceSystem targetCRS;
        CoordinateSystem cs;
        CoordinateReferenceSystem crs;
        ArgumentChecks.ensureNonNull("operation", operation);
        if (envelope == null) {
            return null;
        }
        boolean isOperationComplete = true;
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        if (sourceCRS != null && (crs = envelope.getCoordinateReferenceSystem()) != null && !Utilities.equalsIgnoreMetadata(crs, sourceCRS)) {
            MathTransform mt;
            try {
                mt = CoordinateOperations.factory().createOperation(crs, sourceCRS).getMathTransform();
            }
            catch (FactoryException e) {
                throw new TransformException(Errors.format((short)16), (Throwable)e);
            }
            if (!mt.isIdentity()) {
                isOperationComplete = false;
                envelope = Envelopes.transform(mt, envelope);
            }
        }
        MathTransform mt = operation.getMathTransform();
        double[] centerPt = new double[mt.getTargetDimensions()];
        GeneralEnvelope transformed = Envelopes.transform(mt, envelope, centerPt);
        if (sourceCRS != null && (cs = sourceCRS.getCoordinateSystem()) != null) {
            GeneralDirectPosition sourcePt = null;
            DirectPosition targetPt = null;
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                boolean b2;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null) continue;
                double min = envelope.getMinimum(i);
                double max = envelope.getMaximum(i);
                double v1 = axis.getMinimumValue();
                double v2 = axis.getMaximumValue();
                boolean b1 = v1 > min && v1 < max;
                boolean bl = b2 = v2 > min && v2 < max;
                if (!b1 && !b2) continue;
                if (sourcePt == null) {
                    sourcePt = new GeneralDirectPosition(dimension);
                    for (int j = 0; j < dimension; ++j) {
                        sourcePt.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (b1) {
                    sourcePt.setOrdinate(i, v1);
                    targetPt = mt.transform((DirectPosition)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                if (b2) {
                    sourcePt.setOrdinate(i, v2);
                    targetPt = mt.transform((DirectPosition)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                sourcePt.setOrdinate(i, envelope.getMedian(i));
            }
        }
        if ((targetCRS = operation.getTargetCRS()) == null) {
            return transformed;
        }
        transformed.setCoordinateReferenceSystem(targetCRS);
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null) {
            return transformed;
        }
        Throwable warning = null;
        AbstractEnvelope generalEnvelope = null;
        DirectPosition sourcePt = null;
        GeneralDirectPosition targetPt = null;
        long includedMinValue = 0L;
        long includedMaxValue = 0L;
        long isWrapAroundAxis = 0L;
        long dimensionBitMask = 1L;
        int dimension = targetCS.getDimension();
        int i = 0;
        block10: while (i < dimension) {
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            if (axis != null) {
                boolean testMax = false;
                do {
                    double extremum;
                    double d = extremum = testMax ? axis.getMaximumValue() : axis.getMinimumValue();
                    if (!Double.isFinite(extremum)) continue;
                    if (targetPt == null) {
                        try {
                            mt = mt.inverse();
                        }
                        catch (NoninvertibleTransformException exception) {
                            if (dimension < mt.getSourceDimensions()) break block10;
                            warning = exception;
                            break block10;
                        }
                        targetPt = new GeneralDirectPosition(mt.getSourceDimensions());
                        for (int j = 0; j < dimension; ++j) {
                            targetPt.setOrdinate(j, centerPt[j]);
                        }
                        generalEnvelope = AbstractEnvelope.castOrCopy(envelope);
                    }
                    targetPt.setOrdinate(i, extremum);
                    try {
                        sourcePt = mt.transform(targetPt, sourcePt);
                    }
                    catch (TransformException exception) {
                        if (warning == null) {
                            warning = exception;
                            continue;
                        }
                        warning.addSuppressed((Throwable)exception);
                        continue;
                    }
                    if (!generalEnvelope.contains(sourcePt)) continue;
                    transformed.add(targetPt);
                    if (testMax) {
                        includedMaxValue |= dimensionBitMask;
                        continue;
                    }
                    includedMinValue |= dimensionBitMask;
                } while (testMax = !testMax);
                if ((includedMinValue & includedMaxValue & dimensionBitMask) == 0L && CoordinateOperations.isWrapAround(axis)) {
                    isWrapAroundAxis |= dimensionBitMask;
                }
                if (targetPt != null) {
                    targetPt.setOrdinate(i, centerPt[i]);
                }
            }
            ++i;
            dimensionBitMask <<= 1;
        }
        if ((includedBoundsValue = includedMinValue | includedMaxValue) != 0L) {
            while (isWrapAroundAxis != 0L) {
                long bm;
                int wrapAroundDimension = Long.numberOfTrailingZeros(isWrapAroundAxis);
                dimensionBitMask = 1 << wrapAroundDimension;
                isWrapAroundAxis &= dimensionBitMask ^ 0xFFFFFFFFFFFFFFFFL;
                CoordinateSystemAxis wrapAroundAxis = targetCS.getAxis(wrapAroundDimension);
                double min = wrapAroundAxis.getMinimumValue();
                double max = wrapAroundAxis.getMaximumValue();
                for (long am = includedBoundsValue & (dimensionBitMask ^ 0xFFFFFFFFFFFFFFFFL); am != 0L; am &= bm ^ 0xFFFFFFFFFFFFFFFFL) {
                    bm = Long.lowestOneBit(am);
                    int axisIndex = Long.numberOfTrailingZeros(bm);
                    CoordinateSystemAxis axis = targetCS.getAxis(axisIndex);
                    for (int c = 0; c < 4; ++c) {
                        double value = max;
                        if ((c & 1) == 0) {
                            if (((c == 0 ? includedMinValue : includedMaxValue) & bm) == 0L) {
                                ++c;
                                continue;
                            }
                            targetPt.setOrdinate(axisIndex, c == 0 ? axis.getMinimumValue() : axis.getMaximumValue());
                            value = min;
                        }
                        targetPt.setOrdinate(wrapAroundDimension, value);
                        try {
                            sourcePt = mt.transform((DirectPosition)targetPt, sourcePt);
                        }
                        catch (TransformException exception) {
                            if (warning == null) {
                                warning = exception;
                                continue;
                            }
                            warning.addSuppressed((Throwable)exception);
                            continue;
                        }
                        if (!generalEnvelope.contains(sourcePt)) continue;
                        transformed.add(targetPt);
                    }
                    targetPt.setOrdinate(axisIndex, centerPt[axisIndex]);
                }
                targetPt.setOrdinate(wrapAroundDimension, centerPt[wrapAroundDimension]);
            }
        }
        Set<Integer> wrapAroundChanges = isOperationComplete && operation instanceof AbstractCoordinateOperation ? ((AbstractCoordinateOperation)operation).getWrapAroundChanges() : CoordinateOperations.wrapAroundChanges(sourceCRS, targetCS);
        transformed.normalize(targetCS, 0, wrapAroundChanges.size(), wrapAroundChanges.iterator());
        if (warning != null) {
            Envelopes.recoverableException(Envelopes.class, (TransformException)warning);
        }
        return transformed;
    }

    public static Envelope fromWKT(CharSequence wkt) throws FactoryException {
        ArgumentChecks.ensureNonNull("wkt", wkt);
        try {
            return new GeneralEnvelope(wkt);
        }
        catch (IllegalArgumentException e) {
            throw new FactoryException(Errors.format((short)154, Envelope.class), (Throwable)e);
        }
    }

    public static String toString(Envelope envelope) {
        return AbstractEnvelope.toString(envelope, false);
    }

    public static String toPolygonWKT(Envelope envelope) throws IllegalArgumentException {
        double length;
        int dimension;
        for (dimension = envelope.getDimension(); dimension != 0 && !Double.isFinite(length = envelope.getSpan(dimension - 1)); --dimension) {
        }
        if (dimension < 2) {
            throw new IllegalArgumentException(Errors.format((short)31));
        }
        StringBuilder buffer = new StringBuilder("POLYGON(");
        String separator = "(";
        for (int corner = 0; corner < CORNERS.length; corner += 2) {
            for (int i = 0; i < dimension; ++i) {
                double value;
                switch (i) {
                    case 0: 
                    case 1: {
                        value = CORNERS[corner + i] ? envelope.getMaximum(i) : envelope.getMinimum(i);
                        break;
                    }
                    default: {
                        value = envelope.getMedian(i);
                    }
                }
                StringBuilders.trimFractionalPart(buffer.append(separator).append(value));
                separator = " ";
            }
            separator = ", ";
        }
        return buffer.append("))").toString();
    }
}

