/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Time;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Ellipsoid;

public class CoordinateFormat
extends CompoundFormat<DirectPosition> {
    private static final long serialVersionUID = 8324486673169133932L;
    private static final int READ_AHEAD_LIMIT = 256;
    private static final int DEFAULT_DIMENSION = 4;
    private String separator = " ";
    private String parseSeparator = " ";
    private CoordinateReferenceSystem defaultCRS;
    private transient CoordinateReferenceSystem lastCRS;
    private static final byte LONGITUDE = 1;
    private static final byte LATITUDE = 2;
    private static final byte ANGLE = 3;
    private static final byte DATE = 4;
    private static final byte TIME = 5;
    private transient byte[] types;
    private transient Format[] formats;
    private transient Unit<?>[] units;
    private transient UnitConverter[] toFormatUnit;
    private transient String[] unitSymbols;
    private transient long negate;
    private transient long[] epochs;
    private transient FieldPosition dummy;
    private transient StringBuffer buffer;

    public CoordinateFormat() {
        this(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
    }

    public CoordinateFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        ArgumentChecks.ensureNonEmpty("separator", separator);
        this.separator = separator;
        this.parseSeparator = CharSequences.trimWhitespaces(separator);
        if (this.parseSeparator.isEmpty()) {
            this.parseSeparator = separator;
        }
    }

    public CoordinateReferenceSystem getDefaultCRS() {
        return this.defaultCRS;
    }

    public void setDefaultCRS(CoordinateReferenceSystem crs) {
        this.defaultCRS = crs;
    }

    private void initialize(CoordinateReferenceSystem crs) {
        this.types = null;
        this.formats = null;
        this.units = null;
        this.toFormatUnit = null;
        this.unitSymbols = null;
        this.epochs = null;
        this.negate = 0L;
        this.lastCRS = crs;
        if (crs == null) {
            return;
        }
        CoordinateSystem cs = crs.getCoordinateSystem();
        if (cs == null) {
            return;
        }
        int dimension = cs.getDimension();
        byte[] types = new byte[dimension];
        Format[] formats = new Format[dimension];
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis axis = cs.getAxis(i);
            if (axis == null) {
                formats[i] = this.getFormat(Number.class);
                continue;
            }
            Unit unit = axis.getUnit();
            if (Units.isAngular(unit)) {
                int type = 3;
                AxisDirection dir = axis.getDirection();
                if (AxisDirection.NORTH.equals((Object)dir)) {
                    type = 2;
                } else if (AxisDirection.EAST.equals((Object)dir)) {
                    type = 1;
                } else if (AxisDirection.SOUTH.equals((Object)dir)) {
                    type = 2;
                    this.negate(i);
                } else if (AxisDirection.WEST.equals((Object)dir)) {
                    type = 1;
                    this.negate(i);
                }
                types[i] = type;
                formats[i] = this.getFormat(org.apache.sis.measure.Angle.class);
                this.setConverter(dimension, i, unit.asType(Angle.class).getConverterTo(Units.DEGREE));
                continue;
            }
            if (Units.isTemporal(unit)) {
                CoordinateReferenceSystem t = CRS.getComponentAt(crs, i, i + 1);
                if (t instanceof TemporalCRS) {
                    if (this.epochs == null) {
                        this.epochs = new long[dimension];
                    }
                    types[i] = 4;
                    formats[i] = this.getFormat(Date.class);
                    this.epochs[i] = ((TemporalCRS)t).getDatum().getOrigin().getTime();
                    this.setConverter(dimension, i, unit.asType(Time.class).getConverterTo(Units.MILLISECOND));
                    if (!AxisDirection.PAST.equals((Object)axis.getDirection())) continue;
                    this.negate(i);
                    continue;
                }
                types[i] = 5;
            }
            formats[i] = this.getFormat(Number.class);
            if (unit == null) continue;
            if (this.units == null) {
                this.units = new Unit[dimension];
            }
            this.units[i] = unit;
            String symbol = this.getFormat(Unit.class).format(unit);
            if (symbol.isEmpty()) continue;
            if (this.unitSymbols == null) {
                this.unitSymbols = new String[dimension];
            }
            this.unitSymbols[i] = symbol;
        }
        this.types = types;
        this.formats = formats;
    }

    private void setConverter(int dimension, int i, UnitConverter c) {
        if (!c.isIdentity()) {
            if (this.toFormatUnit == null) {
                this.toFormatUnit = new UnitConverter[dimension];
            }
            this.toFormatUnit[i] = c;
        }
    }

    private void negate(int dimension) {
        if (dimension >= 64) {
            throw new ArithmeticException(Errors.format((short)37, dimension));
        }
        this.negate |= 1L << dimension;
    }

    private boolean isNegative(int dimension) {
        return (this.negate & Numerics.bitmask(dimension)) != 0L;
    }

    public void setPrecision(double resolution, Unit<?> unit) {
        CoordinateSystem cs;
        ArgumentChecks.ensureFinite("resolution", resolution);
        ArgumentChecks.ensureNonNull("unit", unit);
        resolution = Math.abs(resolution);
        if (Units.isTemporal(unit)) {
            return;
        }
        Resolution specified = new Resolution(resolution, unit, Units.isAngular(unit));
        Resolution related = null;
        IncommensurableException error = null;
        if (specified.isAngular || Units.isLinear(unit)) {
            try {
                related = specified.related(ReferencingUtilities.getEllipsoid(this.defaultCRS));
            }
            catch (IncommensurableException e) {
                error = e;
            }
        }
        boolean relatedUsed = false;
        if (this.defaultCRS != null && (cs = this.defaultCRS.getCoordinateSystem()) != null) {
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                Unit axisUnit;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null || (axisUnit = axis.getUnit()) == null) continue;
                try {
                    double maxValue = Math.max(Math.abs(axis.getMinimumValue()), Math.abs(axis.getMaximumValue()));
                    if (specified.forAxis(maxValue, axisUnit) || related == null) continue;
                    relatedUsed |= related.forAxis(maxValue, axisUnit);
                    continue;
                }
                catch (IncommensurableException e) {
                    if (error == null) {
                        error = e;
                        continue;
                    }
                    error.addSuppressed((Throwable)e);
                }
            }
        }
        if (error != null) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.measure"), CoordinateFormat.class, "setPrecision", error);
        }
        specified.setPrecision(this);
        if (relatedUsed) {
            related.setPrecision(this);
        }
    }

    public String getPattern(Class<?> valueType) {
        Format format = this.getFormat(valueType);
        if (format instanceof AngleFormat) {
            return ((AngleFormat)format).toPattern();
        }
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).toPattern();
        }
        if (format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        return null;
    }

    public boolean applyPattern(Class<?> valueType, String pattern) {
        ArgumentChecks.ensureNonNull("pattern", pattern);
        Format format = this.getFormat(valueType);
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern(pattern);
        } else if (format instanceof SimpleDateFormat) {
            ((SimpleDateFormat)format).applyPattern(pattern);
        } else if (format instanceof AngleFormat) {
            ((AngleFormat)format).applyPattern(pattern);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public final Class<DirectPosition> getValueType() {
        return DirectPosition.class;
    }

    public String format(DirectPosition position) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.setLength(0);
        try {
            this.format(position, (Appendable)this.buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.buffer.toString();
    }

    @Override
    public void format(DirectPosition position, Appendable toAppendTo) throws IOException {
        StringBuffer destination;
        ArgumentChecks.ensureNonNull("position", position);
        ArgumentChecks.ensureNonNull("toAppendTo", toAppendTo);
        CoordinateReferenceSystem crs = position.getCoordinateReferenceSystem();
        if (crs == null) {
            crs = this.defaultCRS;
        }
        if (crs != this.lastCRS) {
            this.initialize(crs);
        }
        if (toAppendTo instanceof StringBuffer) {
            destination = (StringBuffer)toAppendTo;
        } else {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            destination = this.buffer;
            destination.setLength(0);
        }
        if (this.dummy == null) {
            this.dummy = new FieldPosition(0);
        }
        int dimension = position.getDimension();
        for (int i = 0; i < dimension; ++i) {
            String symbol;
            Comparable<Double> object;
            Format f;
            double value = position.getOrdinate(i);
            if (this.formats != null && i < this.formats.length) {
                UnitConverter c;
                f = this.formats[i];
                if (this.isNegative(i)) {
                    value = -value;
                }
                if (this.toFormatUnit != null && (c = this.toFormatUnit[i]) != null) {
                    value = c.convert(value);
                }
                switch (this.types[i]) {
                    default: {
                        object = value;
                        break;
                    }
                    case 1: {
                        object = new Longitude(value);
                        break;
                    }
                    case 2: {
                        object = new Latitude(value);
                        break;
                    }
                    case 3: {
                        object = new org.apache.sis.measure.Angle(value);
                        break;
                    }
                    case 4: {
                        object = new Date(Math.round(value) + this.epochs[i]);
                        break;
                    }
                }
            } else {
                object = value;
                f = this.getFormat(Number.class);
            }
            if (i != 0) {
                toAppendTo.append(this.separator);
            }
            if (f.format(object, destination, this.dummy) != toAppendTo) {
                toAppendTo.append(destination);
                destination.setLength(0);
            }
            if (this.unitSymbols == null || i >= this.unitSymbols.length || (symbol = this.unitSymbols[i]) == null) continue;
            toAppendTo.append('\u00a0').append(symbol);
        }
    }

    @Override
    public DirectPosition parse(CharSequence text, ParsePosition pos) throws ParseException {
        double[] coordinates;
        Format format;
        Format[] formats;
        String asString;
        ParsePosition subPos;
        int offset;
        ArgumentChecks.ensureNonNull("text", text);
        ArgumentChecks.ensureNonNull("pos", pos);
        int start = pos.getIndex();
        int length = text.length();
        if (text instanceof String) {
            offset = 0;
            subPos = pos;
            asString = (String)text;
        } else {
            offset = start;
            subPos = new ParsePosition(0);
            asString = text.subSequence(start, Math.min(start + 256, length)).toString();
        }
        if (this.lastCRS != this.defaultCRS) {
            this.initialize(this.defaultCRS);
        }
        if ((formats = this.formats) != null) {
            format = null;
            coordinates = new double[formats.length];
        } else {
            format = this.getFormat(Number.class);
            coordinates = new double[4];
        }
        for (int i = 0; i < coordinates.length; ++i) {
            UnitConverter c;
            Unit<?> target;
            Object object;
            if (i != 0) {
                int end = subPos.getIndex();
                int index = offset + end;
                while (!CharSequences.regionMatches(text, index, this.parseSeparator)) {
                    int c2;
                    if (index < length && Character.isSpaceChar(c2 = Character.codePointAt(text, index))) {
                        index += Character.charCount(c2);
                        continue;
                    }
                    if (formats == null) {
                        pos.setIndex(index);
                        return new GeneralDirectPosition(Arrays.copyOf(coordinates, i));
                    }
                    pos.setIndex(start);
                    pos.setErrorIndex(index);
                    throw new LocalizedParseException(this.getLocale(), 135, new CharSequence[]{text.subSequence(start, end), CharSequences.token(text, index)}, index);
                }
                subPos.setIndex(index + this.parseSeparator.length() - offset);
            }
            if (formats != null) {
                format = formats[i];
            }
            if ((object = format.parseObject(asString, subPos)) == null) {
                Class type = Number.class;
                if (this.types != null) {
                    switch (this.types[i]) {
                        case 1: {
                            type = Longitude.class;
                            break;
                        }
                        case 2: {
                            type = Latitude.class;
                            break;
                        }
                        case 3: {
                            type = org.apache.sis.measure.Angle.class;
                            break;
                        }
                        case 4: {
                            type = Date.class;
                        }
                    }
                }
                pos.setIndex(start);
                if (subPos != pos) {
                    pos.setErrorIndex(offset + subPos.getErrorIndex());
                }
                throw new LocalizedParseException(this.getLocale(), type, text, pos);
            }
            double value = object instanceof org.apache.sis.measure.Angle ? ((org.apache.sis.measure.Angle)object).degrees() : (object instanceof Date ? (double)(((Date)object).getTime() - this.epochs[i]) : ((Number)object).doubleValue());
            if (this.units != null && (target = this.units[i]) != null) {
                int base;
                int c3;
                for (int index = base = subPos.getIndex(); index < asString.length(); index += Character.charCount(c3)) {
                    c3 = asString.codePointAt(index);
                    if (Character.isSpaceChar(c3)) {
                        continue;
                    }
                    subPos.setIndex(index);
                    Object unit = this.getFormat(Unit.class).parseObject(asString, subPos);
                    if (unit == null) {
                        subPos.setIndex(base);
                        subPos.setErrorIndex(-1);
                        break;
                    }
                    try {
                        value = ((Unit)unit).getConverterToAny(target).convert(value);
                        break;
                    }
                    catch (IncommensurableException e) {
                        pos.setIndex(start);
                        pos.setErrorIndex(index += offset);
                        throw (ParseException)new ParseException(e.getMessage(), index).initCause(e);
                    }
                }
            }
            if (this.toFormatUnit != null && (c = this.toFormatUnit[i]) != null) {
                value = c.inverse().convert(value);
            }
            if (this.isNegative(i)) {
                value = -value;
            }
            coordinates[i] = value;
        }
        GeneralDirectPosition position = new GeneralDirectPosition(coordinates);
        position.setCoordinateReferenceSystem(this.defaultCRS);
        return position;
    }

    @Override
    public CoordinateFormat clone() {
        CoordinateFormat clone = (CoordinateFormat)super.clone();
        clone.dummy = null;
        clone.buffer = null;
        Format[] cf = clone.formats;
        if (cf != null) {
            clone.formats = cf = (Format[])cf.clone();
            for (int i = 0; i < cf.length; ++i) {
                cf[i] = (Format)cf[i].clone();
            }
        }
        return clone;
    }

    private static final class Resolution {
        private double resolution;
        private double magnitude;
        private Unit<?> unit;
        final boolean isAngular;

        Resolution(double resolution, Unit<?> unit, boolean isAngular) {
            this.resolution = resolution;
            this.unit = unit;
            this.isAngular = isAngular;
        }

        Resolution related(Ellipsoid ellipsoid) throws IncommensurableException {
            Unit<Angle> relatedUnit;
            double radius = Formulas.getAuthalicRadius(ellipsoid);
            if (radius > 0.0 && (relatedUnit = ellipsoid.getAxisUnit()) != null) {
                double related;
                if (this.isAngular) {
                    related = this.unit.getConverterToAny(Units.RADIAN).convert(this.resolution) * radius;
                } else {
                    related = Math.toDegrees(this.unit.getConverterToAny((Unit)relatedUnit).convert(this.resolution) / radius);
                    relatedUnit = Units.DEGREE;
                }
                return new Resolution(related, relatedUnit, !this.isAngular);
            }
            return null;
        }

        boolean forAxis(double maxValue, Unit<?> axisUnit) throws IncommensurableException {
            if (!axisUnit.isCompatible(this.unit)) {
                return false;
            }
            UnitConverter c = this.unit.getConverterToAny(axisUnit);
            double r = Math.abs(c.convert(this.resolution));
            if (r < this.resolution) {
                this.resolution = r;
                this.unit = axisUnit;
            } else {
                maxValue = Math.abs(c.inverse().convert(maxValue));
            }
            if (maxValue > this.magnitude) {
                this.magnitude = maxValue;
            }
            return true;
        }

        void setPrecision(CoordinateFormat owner) {
            Format format = owner.getFormat(this.isAngular ? org.apache.sis.measure.Angle.class : Number.class);
            if (format instanceof NumberFormat) {
                if (this.resolution == 0.0) {
                    this.resolution = 1.0E-6;
                }
                int p = Math.max(0, DecimalFunctions.fractionDigitsForDelta(this.resolution, true));
                int m = Math.max(0, DecimalFunctions.fractionDigitsForDelta(Math.ulp(this.magnitude), false));
                ((NumberFormat)format).setMinimumFractionDigits(Math.min(p, m));
                ((NumberFormat)format).setMaximumFractionDigits(p);
            } else if (format instanceof AngleFormat) {
                ((AngleFormat)format).setPrecision(this.resolution, true);
            }
        }
    }
}

