/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.CommonParentFinder;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.InvalidFeatureException;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.Static;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.Result;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

public final class Features
extends Static {
    private Features() {
    }

    public static <V> DefaultAttributeType<V> cast(DefaultAttributeType<?> type, Class<V> valueClass) throws ClassCastException {
        Class<?> actual;
        if (type != null && !valueClass.equals(actual = type.getValueClass())) {
            throw new ClassCastException(Resources.format((short)13, type.getName(), valueClass, actual));
        }
        return type;
    }

    public static <V> AbstractAttribute<V> cast(AbstractAttribute<?> attribute, Class<V> valueClass) throws ClassCastException {
        Class<?> actual;
        if (attribute != null && !valueClass.equals(actual = attribute.getType().getValueClass())) {
            throw new ClassCastException(Resources.format((short)13, attribute.getName(), valueClass, actual));
        }
        return attribute;
    }

    public static DefaultFeatureType findCommonParent(Iterable<? extends DefaultFeatureType> types) {
        return types != null ? CommonParentFinder.select(types) : null;
    }

    public static GenericName getValueTypeName(AbstractIdentifiedType property) {
        AbstractIdentifiedType result;
        if (property instanceof DefaultAssociationRole) {
            return DefaultAssociationRole.getValueTypeName((DefaultAssociationRole)property);
        }
        if (property instanceof DefaultAttributeType) {
            DefaultNameFactory factory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
            return factory.toTypeName(((DefaultAttributeType)property).getValueClass());
        }
        if (property instanceof AbstractOperation && (result = ((AbstractOperation)property).getResult()) != null) {
            return result.getName();
        }
        return null;
    }

    public static void validate(AbstractFeature feature) throws IllegalArgumentException {
        if (feature != null) {
            DataQuality quality = feature.quality();
            for (Element element : quality.getReports()) {
                for (Result result : element.getResults()) {
                    InternationalString message;
                    if (!(result instanceof ConformanceResult) || !Boolean.FALSE.equals(((ConformanceResult)result).pass()) || (message = ((ConformanceResult)result).getExplanation()) == null) continue;
                    throw new InvalidFeatureException(message);
                }
            }
        }
    }
}

