/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.Property;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class EnvelopeOperation
extends AbstractOperation {
    private static final long serialVersionUID = 6250548001562807671L;
    private static final ParameterDescriptorGroup EMPTY_PARAMS = FeatureUtilities.parameters("Envelope", new ParameterDescriptor[0]);
    private final String[] attributeNames;
    final CoordinateReferenceSystem crs;
    private final CoordinateOperation[] attributeToCRS;
    private transient Set<String> dependencies;
    private final DefaultAttributeType<Envelope> resultType;

    EnvelopeOperation(Map<String, ?> identification, CoordinateReferenceSystem crs, AbstractIdentifiedType[] geometryAttributes) throws FactoryException {
        super(identification);
        Object name;
        String defaultGeometry = null;
        String characteristicName = AttributeConvention.CRS_CHARACTERISTIC.toString();
        boolean characterizedByCRS = false;
        LinkedHashMap<String, CoordinateReferenceSystem> names = new LinkedHashMap<String, CoordinateReferenceSystem>(4);
        for (AbstractIdentifiedType property : geometryAttributes) {
            if (!AttributeConvention.isGeometryAttribute(property)) continue;
            name = property.getName();
            String attributeName = property instanceof LinkOperation ? ((LinkOperation)property).referentName : name.toString();
            boolean isDefault = AttributeConvention.GEOMETRY_PROPERTY.equals(name);
            if (isDefault) {
                defaultGeometry = attributeName;
            }
            CoordinateReferenceSystem attributeCRS = null;
            while (property instanceof AbstractOperation) {
                property = ((AbstractOperation)property).getResult();
            }
            DefaultAttributeType<?> at = ((DefaultAttributeType)property).characteristics().get(characteristicName);
            if (at != null && CoordinateReferenceSystem.class.isAssignableFrom(at.getValueClass())) {
                attributeCRS = (CoordinateReferenceSystem)at.getDefaultValue();
                if (crs == null && isDefault) {
                    crs = attributeCRS;
                }
                characterizedByCRS = true;
            }
            names.putIfAbsent(attributeName, attributeCRS);
        }
        names.remove(null);
        this.attributeNames = new String[names.size()];
        this.attributeToCRS = characterizedByCRS ? new CoordinateOperation[this.attributeNames.length] : null;
        int n = defaultGeometry == null ? 0 : 1;
        for (Map.Entry entry : names.entrySet()) {
            CoordinateOperation op;
            CoordinateReferenceSystem value;
            int i;
            name = (String)entry.getKey();
            if (((String)name).equals(defaultGeometry)) {
                defaultGeometry = null;
                i = 0;
            } else {
                i = n++;
            }
            this.attributeNames[i] = name;
            if (!characterizedByCRS || (value = (CoordinateReferenceSystem)entry.getValue()) == null) continue;
            if (crs == null) {
                crs = value;
            }
            if ((op = CRS.findOperation(value, crs, null)).getMathTransform().isIdentity()) continue;
            this.attributeToCRS[i] = op;
        }
        this.resultType = FeatureOperations.POOL.unique(new DefaultAttributeType<Object>(this.resultIdentification(identification), Envelope.class, 1, 1, null, new DefaultAttributeType[0]));
        this.crs = crs;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public synchronized Set<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = CollectionsExt.immutableSet(true, this.attributeNames);
        }
        return this.dependencies;
    }

    @Override
    public Property apply(AbstractFeature feature, ParameterValueGroup parameters) {
        return new Result(feature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.attributeNames) + Arrays.hashCode(this.attributeToCRS);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            EnvelopeOperation that = (EnvelopeOperation)obj;
            return Arrays.equals(this.attributeNames, that.attributeNames) && Arrays.equals(this.attributeToCRS, that.attributeToCRS) && Objects.equals(this.crs, that.crs);
        }
        return false;
    }

    private final class Result
    extends AbstractAttribute<Envelope> {
        private static final long serialVersionUID = 926172863066901618L;
        private final AbstractFeature feature;

        Result(AbstractFeature feature) {
            super(EnvelopeOperation.this.resultType);
            this.feature = feature;
        }

        @Override
        public Envelope getValue() throws IllegalStateException {
            String[] attributeNames = EnvelopeOperation.this.attributeNames;
            GeneralEnvelope envelope = null;
            for (int i = 0; i < attributeNames.length; ++i) {
                GeneralEnvelope genv;
                String name = attributeNames[i];
                if (EnvelopeOperation.this.attributeToCRS == null) {
                    genv = Geometries.getEnvelope(this.feature.getPropertyValue(name));
                    if (genv == null) {
                        continue;
                    }
                } else {
                    Property property = (Property)this.feature.getProperty(name);
                    genv = Geometries.getEnvelope(property.getValue());
                    if (genv == null) continue;
                    AbstractAttribute<?> at = ((AbstractAttribute)property).characteristics().get(AttributeConvention.CRS_CHARACTERISTIC.toString());
                    try {
                        if (at == null) {
                            CoordinateOperation op = EnvelopeOperation.this.attributeToCRS[i];
                            if (op != null) {
                                genv = Envelopes.transform(op, (Envelope)genv);
                            }
                        } else {
                            Object geomCRS = at.getValue();
                            if (!(geomCRS instanceof CoordinateReferenceSystem)) {
                                throw new IllegalStateException(Errors.format((short)157));
                            }
                            genv.setCoordinateReferenceSystem((CoordinateReferenceSystem)geomCRS);
                            genv = Envelopes.transform(genv, EnvelopeOperation.this.crs);
                        }
                    }
                    catch (TransformException e) {
                        throw new IllegalStateException(Errors.format((short)16), e);
                    }
                }
                if (envelope == null) {
                    envelope = GeneralEnvelope.castOrCopy(genv);
                    continue;
                }
                envelope.add(genv);
            }
            return envelope;
        }

        @Override
        public void setValue(Envelope value) {
            throw new UnsupportedOperationException(Errors.format((short)153, AbstractAttribute.class));
        }
    }
}

