/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;

final class SampleRangeFormat
extends RangeFormat {
    private static final int MAX_DIGITS = 6;
    private int[] numFractionDigits;
    private boolean hasPackedValues;
    private boolean hasQuantitative;
    private final Vocabulary words;
    private int currentIndex;

    SampleRangeFormat(Locale locale) {
        super(locale);
        this.words = Vocabulary.getResources(locale);
    }

    private void prepare(SampleDimension[] dimensions) {
        int count = dimensions.length;
        this.numFractionDigits = new int[count];
        this.hasPackedValues = false;
        this.hasQuantitative = false;
        for (int i = 0; i < count; ++i) {
            int ndigits = 0;
            for (Category category : dimensions[i].getCategories()) {
                NumberRange<?> sr = category.getSampleRange();
                NumberRange<?> cr = category.converted().range;
                double smin = sr.getMinDouble(true);
                double smax = sr.getMaxDouble(false);
                double cmin = cr.getMinDouble(true);
                double cmax = cr.getMaxDouble(false);
                boolean isPacked = Double.doubleToRawLongBits(smin) != Double.doubleToRawLongBits(cmin) | Double.doubleToRawLongBits(smax) != Double.doubleToRawLongBits(cmax);
                this.hasPackedValues |= isPacked;
                double range = isPacked ? smax - smin : 256.0;
                double increment = (cmax - cmin) / range;
                if (Double.isNaN(increment)) continue;
                this.hasQuantitative = true;
                int n = -Numerics.toExp10(Math.getExponent(increment));
                if (n <= ndigits) continue;
                ndigits = n;
            }
            if (ndigits >= 6) {
                ndigits = 6;
            }
            this.numFractionDigits[i] = ndigits;
        }
    }

    private String formatSample(Object value) {
        if (value instanceof Number) {
            return Numerics.useScientificNotationIfNeeded(this.elementFormat, value, Format::format).concat("\u00a0");
        }
        if (value instanceof Range) {
            if (value instanceof MeasurementRange) {
                return this.formatMeasure(new NumberRange((MeasurementRange)value));
            }
            return this.format(value);
        }
        return String.valueOf(value);
    }

    private String formatMeasure(Range<?> range) {
        NumberFormat nf = (NumberFormat)this.elementFormat;
        int min = nf.getMinimumFractionDigits();
        int max = nf.getMaximumFractionDigits();
        int ndigits = this.numFractionDigits[this.currentIndex];
        nf.setMinimumFractionDigits(ndigits);
        nf.setMaximumFractionDigits(ndigits);
        String text = this.format(range);
        nf.setMinimumFractionDigits(min);
        nf.setMaximumFractionDigits(max);
        return text;
    }

    String write(SampleDimension[] dimensions) {
        this.prepare(dimensions);
        StringBuilder buffer = new StringBuilder(800);
        TableAppender table = new TableAppender(buffer, " \u2502 ");
        table.setMultiLinesCells(true);
        table.appendHorizontalSeparator();
        table.setCellAlignment((byte)0);
        if (this.hasPackedValues) {
            table.append(this.words.getString((short)158)).nextColumn();
        }
        if (this.hasQuantitative) {
            table.append(this.words.getString((short)157)).nextColumn();
        }
        table.append(this.words.getString((short)72)).nextLine();
        table.nextLine('\u2550');
        table.append('#');
        table.appendHorizontalSeparator();
        for (SampleDimension dim : dimensions) {
            for (Category category : dim.getCategories()) {
                if (this.hasPackedValues) {
                    table.setCellAlignment((byte)1);
                    table.append(this.formatSample(category.getRangeLabel()));
                    table.nextColumn();
                }
                table.setCellAlignment((byte)-1);
                if (this.hasQuantitative) {
                    Category converted = category.converted();
                    String text = converted.isConvertedQualitative() ? String.valueOf(converted.getRangeLabel()) : this.formatMeasure(converted.getSampleRange());
                    table.append(text);
                    table.nextColumn();
                }
                table.append(category.getName().toString(this.getLocale()));
                table.nextLine();
            }
        }
        table.appendHorizontalSeparator();
        try {
            table.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        int lastDimensionEnd = 0;
        String lineSeparator = table.getLineSeparator();
        String toSearch = lineSeparator + '\u255e';
        for (SampleDimension dim : dimensions) {
            int lineStart = buffer.indexOf(toSearch, lastDimensionEnd);
            if (lineStart < 0) break;
            int i = SampleRangeFormat.replace(buffer, lineStart += toSearch.length(), '\u256a', '\u2567', '\u2561');
            int limit = i - 2 - lineStart;
            i += lineSeparator.length() + 2;
            GenericName name = dim.getName();
            String label = name != null ? name.toInternationalString().toString(this.getLocale()) : this.words.getString((short)108);
            if (label.length() > limit) {
                label = label.substring(0, limit);
            }
            limit += i;
            buffer.replace(i, i += label.length(), label);
            while (i < limit) {
                buffer.setCharAt(i++, ' ');
            }
            lastDimensionEnd = SampleRangeFormat.replace(buffer, i + lineSeparator.length() + 2, '\u253c', '\u252c', '\u2524');
        }
        return buffer.toString();
    }

    private static int replace(StringBuilder buffer, int i, char search, char replace, char stop) {
        char c;
        do {
            if ((c = buffer.charAt(i)) == search) {
                buffer.setCharAt(i, replace);
            }
            ++i;
        } while (c != stop);
        return i;
    }
}

