/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.util.Locale;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.util.resources.Errors;

enum Option {
    SOURCE_CRS(true),
    TARGET_CRS(true),
    FORMAT(true),
    LOCALE(true),
    TIMEZONE(true),
    ENCODING(true),
    COLORS(true),
    BRIEF(false),
    VERBOSE(false),
    DEBUG(false),
    HELP(false);

    static final String PREFIX = "--";
    private static final String[] BOOLEAN_VALUES;
    private String label;
    final boolean hasValue;

    private Option(boolean hasValue) {
        this.hasValue = hasValue;
    }

    String label() {
        if (this.label == null) {
            this.label = this.name().toLowerCase(Locale.US);
        }
        return this.label;
    }

    static Option forLabel(String label) throws InvalidOptionException {
        for (Option option : Option.values()) {
            if (!label.equalsIgnoreCase(option.name().replace("_", ""))) continue;
            return option;
        }
        throw new InvalidOptionException(Errors.format((short)148, label), label);
    }

    boolean parseBoolean(String value) throws InvalidOptionException {
        for (int i = 0; i < BOOLEAN_VALUES.length; ++i) {
            if (!value.equalsIgnoreCase(BOOLEAN_VALUES[i])) continue;
            return (i & 1) != 0;
        }
        String name = this.name().toLowerCase(Locale.US);
        throw new InvalidOptionException(Errors.format((short)56, name, value), name);
    }

    static {
        BOOLEAN_VALUES = new String[]{"false", "true", "off", "on", "no", "yes"};
        Option.SOURCE_CRS.label = "sourceCRS";
        Option.TARGET_CRS.label = "targetCRS";
    }
}

