/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.IOException;
import java.util.EnumSet;
import java.util.ResourceBundle;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.io.TableAppender;
import org.apache.sis.util.resources.Vocabulary;

final class HelpCommand
extends CommandRunner {
    private static final String[] COMMANDS = new String[]{"help", "about", "mime-type", "metadata", "crs", "identifier", "transform"};

    HelpCommand(CommandRunner parent) {
        super(parent);
    }

    HelpCommand(int commandIndex, String ... arguments) throws InvalidOptionException {
        super(commandIndex, arguments, EnumSet.of(Option.LOCALE, Option.ENCODING, Option.HELP, Option.DEBUG));
    }

    @Override
    public int run() throws IOException {
        if (this.hasUnexpectedFileCount(0, 0)) {
            return 3;
        }
        this.help(true, COMMANDS, EnumSet.allOf(Option.class));
        return 0;
    }

    void help(boolean showHeader, String[] commandNames, EnumSet<Option> validOptions) throws IOException {
        ResourceBundle commands = ResourceBundle.getBundle("org.apache.sis.console.Commands", this.locale);
        ResourceBundle options = ResourceBundle.getBundle("org.apache.sis.console.Options", this.locale);
        Vocabulary vocabulary = Vocabulary.getResources(this.locale);
        if (showHeader) {
            this.out.print("Apache SIS, ");
            this.out.println(commands.getString("SIS"));
            this.out.println(commands.getString("Usage"));
            this.out.println();
            this.out.print(vocabulary.getString((short)16));
            this.out.println(':');
        }
        TableAppender table = new TableAppender(this.out, "  ");
        for (String command : commandNames) {
            if (showHeader) {
                table.append("  ");
            }
            table.append(command);
            if (!showHeader) {
                table.append(':');
            }
            table.nextColumn();
            table.append(commands.getString(command));
            table.nextLine();
        }
        table.flush();
        this.out.println();
        this.out.print(vocabulary.getString((short)83));
        this.out.println(':');
        for (Option option : validOptions) {
            String name = option.label();
            table.append("  ").append("--").append(name);
            table.nextColumn();
            table.append(options.getString(name));
            table.nextLine();
        }
        table.flush();
    }
}

