/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.console.HelpCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.internal.util.X364;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Locales;
import org.apache.sis.util.resources.Errors;

abstract class CommandRunner {
    static final String TEST = "TEST";
    static CommandRunner instance;
    protected final String commandName;
    private final EnumSet<Option> validOptions;
    protected final EnumMap<Option, String> options;
    protected final Locale locale;
    protected final TimeZone timezone;
    protected final Charset encoding;
    protected final boolean colors;
    protected final boolean debug;
    protected final PrintWriter out;
    protected final PrintWriter err;
    final StringBuffer outputBuffer;
    protected final List<String> files;

    CommandRunner(CommandRunner parent) {
        this.commandName = parent.commandName;
        this.validOptions = parent.validOptions;
        this.options = parent.options;
        this.locale = parent.locale;
        this.timezone = parent.timezone;
        this.encoding = parent.encoding;
        this.colors = parent.colors;
        this.debug = parent.debug;
        this.out = parent.out;
        this.err = parent.err;
        this.outputBuffer = parent.outputBuffer;
        this.files = parent.files;
    }

    protected CommandRunner(int commandIndex, String[] arguments, EnumSet<Option> validOptions) throws InvalidOptionException {
        Console console;
        boolean explicitEncoding;
        this.commandName = commandIndex >= 0 ? arguments[commandIndex] : null;
        this.validOptions = validOptions;
        this.options = new EnumMap(Option.class);
        this.files = new ArrayList<String>(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            if (i == commandIndex) continue;
            String arg = arguments[i];
            if (arg.startsWith("--")) {
                String name = arg.substring("--".length());
                Option option = Option.forLabel(name);
                if (!validOptions.contains((Object)option)) {
                    throw new InvalidOptionException(Errors.format((short)148, name), name);
                }
                String value = null;
                if (option.hasValue) {
                    if (++i >= arguments.length) {
                        throw new InvalidOptionException(Errors.format((short)88, name), name);
                    }
                    value = arguments[i];
                }
                if (this.options.containsKey((Object)option)) {
                    throw new InvalidOptionException(Errors.format((short)26, name), name);
                }
                this.options.put(option, value);
                continue;
            }
            this.files.add(arg);
        }
        Option option = null;
        String value = null;
        try {
            option = Option.DEBUG;
            this.debug = this.options.containsKey((Object)option);
            option = Option.LOCALE;
            value = this.options.get((Object)option);
            this.locale = value != null ? Locales.parse(value) : Locale.getDefault(Locale.Category.DISPLAY);
            option = Option.TIMEZONE;
            value = this.options.get((Object)option);
            this.timezone = value != null ? TimeZone.getTimeZone(value) : TimeZone.getDefault();
            option = Option.ENCODING;
            value = this.options.get((Object)option);
            explicitEncoding = value != null;
            this.encoding = explicitEncoding ? Charset.forName(value) : Charset.defaultCharset();
            option = Option.COLORS;
            value = this.options.get((Object)option);
            console = System.console();
            this.colors = value != null ? Option.COLORS.parseBoolean(value) : console != null && X364.isAnsiSupported();
        }
        catch (RuntimeException e) {
            String name = option.label();
            throw new InvalidOptionException(Errors.format((short)56, name, value), name);
        }
        if (TEST.equals(this.commandName)) {
            StringWriter s = new StringWriter();
            this.outputBuffer = s.getBuffer();
            this.err = this.out = new PrintWriter(s);
        } else {
            this.outputBuffer = null;
            PrintWriter printWriter = this.err = console != null ? console.writer() : new PrintWriter(System.err, true);
            this.out = !explicitEncoding && console != null ? console.writer() : (explicitEncoding ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, this.encoding), true) : new PrintWriter(System.out, true));
        }
    }

    final boolean hasContradictoryOptions(Option ... exclusive) {
        int i = 0;
        while (i < exclusive.length) {
            Option o1 = exclusive[i++];
            Option o2 = exclusive[i++];
            if (!this.options.containsKey((Object)o1) || !this.options.containsKey((Object)o2)) continue;
            this.err.println(Errors.format((short)91, o1.label(), o2.label()));
            return true;
        }
        return false;
    }

    final boolean hasUnexpectedFileCount(int min, int max) {
        short key;
        int expected;
        int size = this.files.size();
        if (size < min) {
            expected = min;
            key = 127;
        } else if (size > max) {
            expected = max;
            key = 129;
        } else {
            return false;
        }
        this.err.println(Errors.format(key, expected, size));
        return true;
    }

    final boolean useStandardInput() {
        return this.files.isEmpty() && System.console() == null;
    }

    final void canNotOpen(int fileIndex, Exception e) {
        this.error(Errors.format((short)9, this.files.get(fileIndex)), e);
    }

    final void error(String message, Exception e) {
        this.out.flush();
        if (this.debug) {
            e.printStackTrace(this.err);
        } else {
            this.err.println(Exceptions.formatChainedMessages(this.locale, message, e));
        }
    }

    protected void help(String resourceKey) throws IOException {
        new HelpCommand(this).help(false, new String[]{resourceKey}, this.validOptions);
    }

    public abstract int run() throws Exception;
}

