/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.util.HashSet;
import java.util.function.DoubleToIntFunction;
import org.apache.sis.coverage.Category;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.math.MathFunctions;

final class ToNaN
extends HashSet<Integer>
implements DoubleToIntFunction {
    Number background;

    ToNaN() {
    }

    @Override
    public void clear() {
        super.clear();
        this.background = null;
    }

    private boolean isBackground(double d) {
        return this.background != null && d == this.background.doubleValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int applyAsInt(double d) {
        if (this.isBackground(d) && this.add(0)) {
            return 0;
        }
        int n = Math.round((float)d);
        if (n > 0x1FFFFF) {
            n = 0x100000;
        } else if (n < -2097152) {
            n = -1048576;
        }
        if (this.add(n)) return n;
        if (n >= 0) {
            while (!this.add(++n)) {
                if (n < 0x1FFFFF) continue;
                throw new IllegalStateException(Resources.format((short)48));
            }
            return n;
        }
        while (!this.add(--n)) {
            if (n > -2097152) continue;
            throw new IllegalStateException(Resources.format((short)48));
        }
        return n;
    }

    void remove(Category category) {
        float f = (float)category.converse.range.getMinDouble();
        if (Float.isNaN(f) && super.remove(MathFunctions.toNanOrdinal(f)) && this.isBackground(category.range.getMinDouble())) {
            this.background = null;
        }
    }
}

