/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;

public class Symbols
implements Localized,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1730166945430878916L;
    static final boolean SCIENTIFIC_NOTATION = true;
    static final char NUMBER_SEPARATOR = ' ';
    static final char FRAGMENT_VALUE = '$';
    public static final Symbols SQUARE_BRACKETS = new Symbols(new int[]{91, 93, 40, 41}, new int[]{34, 34, 8220, 8221});
    public static final Symbols CURLY_BRACKETS = new Symbols(new int[]{40, 41, 91, 93}, Symbols.SQUARE_BRACKETS.quotes);
    private Locale locale;
    private int[] brackets;
    private int[] quotes;
    private transient String quote;
    private int openSequence;
    private int closeSequence;
    private String separator;
    private transient String trimmedSeparator;
    private boolean isImmutable;

    public Symbols(Symbols symbols) {
        ArgumentChecks.ensureNonNull("symbols", symbols);
        this.locale = symbols.locale;
        this.brackets = symbols.brackets;
        this.quotes = symbols.quotes;
        this.quote = symbols.quote;
        this.openSequence = symbols.openSequence;
        this.closeSequence = symbols.closeSequence;
        this.separator = symbols.separator;
        this.trimmedSeparator = symbols.trimmedSeparator;
    }

    private Symbols(int[] nArray, int[] nArray2) {
        this.locale = Locale.ROOT;
        this.brackets = nArray;
        this.quotes = nArray2;
        this.quote = "\"";
        this.openSequence = 123;
        this.closeSequence = 125;
        this.separator = ", ";
        this.trimmedSeparator = ",";
        this.isImmutable = true;
    }

    final void checkWritePermission() throws UnsupportedOperationException {
        if (this.isImmutable) {
            throw new UnsupportedOperationException(Errors.format((short)153, "Symbols"));
        }
    }

    public static Symbols getDefault() {
        return SQUARE_BRACKETS;
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.checkWritePermission();
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
    }

    private static int matching(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; i += 2) {
            if (nArray[i] != n) continue;
            return nArray[i + 1];
        }
        return -1;
    }

    final int matchingBracket(int n) {
        return Symbols.matching(this.brackets, n);
    }

    public final int getNumPairedBrackets() {
        return this.brackets.length >>> 1;
    }

    public final int getOpeningBracket(int n) {
        return this.brackets[n << 1];
    }

    public final int getClosingBracket(int n) {
        return this.brackets[n << 1 | 1];
    }

    public void setPairedBrackets(String string, String ... stringArray) {
        this.checkWritePermission();
        this.brackets = Symbols.toCodePoints(string, stringArray);
    }

    final int matchingQuote(int n) {
        return Symbols.matching(this.quotes, n);
    }

    public final int getNumPairedQuotes() {
        return this.quotes.length >>> 1;
    }

    public final int getOpeningQuote(int n) {
        return this.quotes[n << 1];
    }

    public final int getClosingQuote(int n) {
        return this.quotes[n << 1 | 1];
    }

    final String getQuote() {
        return this.quote;
    }

    public void setPairedQuotes(String string, String ... stringArray) {
        this.checkWritePermission();
        this.quotes = Symbols.toCodePoints(string, stringArray);
        this.quote = string.substring(Character.charCount(this.quotes[0])).trim();
    }

    private static int[] toCodePoints(String string, String[] stringArray) {
        ArgumentChecks.ensureNonEmpty("preferred", string);
        int n = stringArray != null ? stringArray.length : 0;
        int[] nArray = new int[(n + 1) * 2];
        String string2 = "preferred";
        String string3 = string;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (string3.codePointCount(0, string3.length()) != 2) {
                throw new IllegalArgumentException(Errors.format((short)45, string2, string3));
            }
            int n4 = string3.codePointAt(0);
            int n5 = n3++;
            int n6 = n4;
            nArray[n5] = n6;
            Symbols.ensureValidQuoteOrBracket(string2, n6);
            int n7 = n3++;
            int n8 = string3.codePointAt(Character.charCount(n4));
            nArray[n7] = n8;
            Symbols.ensureValidQuoteOrBracket(string2, n8);
            if (n2 >= n) break;
            string2 = "alternatives";
            int n9 = n2;
            string3 = stringArray[n2++];
            ArgumentChecks.ensureNonNullElement("alternatives", n9, string3);
        }
        return nArray;
    }

    private static void ensureValidQuoteOrBracket(String string, int n) {
        ArgumentChecks.ensureValidUnicodeCodePoint(string, n);
        if (Character.isUnicodeIdentifierPart(n) || Character.isSpaceChar(n) || n == 36) {
            throw new IllegalArgumentException(Errors.format((short)49, string, String.valueOf(Character.toChars(n))));
        }
    }

    public final int getOpenSequence() {
        return this.openSequence;
    }

    public final int getCloseSequence() {
        return this.closeSequence;
    }

    public void setSequenceBrackets(int n, int n2) {
        this.checkWritePermission();
        Symbols.ensureValidQuoteOrBracket("openSequence", n);
        Symbols.ensureValidQuoteOrBracket("closeSequence", n2);
        this.openSequence = n;
        this.closeSequence = n2;
    }

    public final String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.checkWritePermission();
        String string2 = CharSequences.trimWhitespaces(string.trim());
        ArgumentChecks.ensureNonEmpty("separator", string2);
        this.separator = string;
        this.trimmedSeparator = string2;
    }

    final String trimmedSeparator() {
        return this.trimmedSeparator;
    }

    final String separatorNewLine() {
        String string = this.getSeparator();
        return string.substring(0, CharSequences.skipTrailingWhitespaces(string, 0, string.length())).concat(System.lineSeparator());
    }

    final NumberFormat createNumberFormat() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(this.locale);
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    final boolean useScientificNotation(double d) {
        return (d < 0.001 || d >= 1.0E9) && this.locale == Locale.ROOT;
    }

    public boolean containsElement(CharSequence charSequence, String string) {
        ArgumentChecks.ensureNonNull("wkt", charSequence);
        ArgumentChecks.ensureNonEmpty("element", string);
        if (!CharSequences.isUnicodeIdentifier(string)) {
            throw new IllegalArgumentException(Errors.format((short)112, string));
        }
        return this.containsElement(charSequence, string, 0);
    }

    public boolean containsAxis(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("wkt", charSequence);
        return this.containsElement(charSequence, "AXIS", 0);
    }

    private boolean containsElement(CharSequence charSequence, String string, int n) {
        int[] nArray = this.quotes;
        int n2 = charSequence.length();
        boolean bl = false;
        int n3 = 0;
        while (n < n2) {
            int n4;
            block8: {
                block7: {
                    n4 = Character.codePointAt(charSequence, n);
                    if (n3 == 0) break block7;
                    if (n4 != n3) break block8;
                    bl = false;
                    break block8;
                }
                for (int i = 0; i < nArray.length; i += 2) {
                    if (n4 != nArray[i]) continue;
                    n3 = nArray[i | 1];
                    bl = true;
                    break;
                }
            }
            if (!bl && Character.isUnicodeIdentifierStart(n4)) {
                if (CharSequences.regionMatches(charSequence, n, string, true)) {
                    if ((n = CharSequences.skipLeadingWhitespaces(charSequence, n + string.length(), n2)) >= n2) break;
                    n4 = Character.codePointAt(charSequence, n);
                    if (this.matchingBracket(n4) >= 0) {
                        return true;
                    }
                } else {
                    do {
                        if ((n += Character.charCount(n4)) < n2) continue;
                        return false;
                    } while (Character.isUnicodeIdentifierPart(n4 = Character.codePointAt(charSequence, n)));
                }
            }
            n += Character.charCount(n4);
        }
        return false;
    }

    final Symbols immutable() {
        if (this.isImmutable) {
            return this;
        }
        Symbols symbols = this.clone();
        symbols.isImmutable = true;
        return symbols;
    }

    public Symbols clone() {
        Symbols symbols;
        try {
            symbols = (Symbols)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        symbols.isImmutable = false;
        return symbols;
    }

    public boolean equals(Object object) {
        if (object instanceof Symbols) {
            Symbols symbols = (Symbols)object;
            return Arrays.equals(this.brackets, symbols.brackets) && Arrays.equals(this.quotes, symbols.quotes) && this.openSequence == symbols.openSequence && this.closeSequence == symbols.closeSequence && this.separator.equals(symbols.separator) && this.locale.equals(symbols.locale);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.brackets, this.quotes, this.openSequence, this.closeSequence, this.separator, this.locale});
    }

    final Object readResolve() throws ObjectStreamException {
        if (this.isImmutable) {
            if (this.equals(SQUARE_BRACKETS)) {
                return SQUARE_BRACKETS;
            }
            if (this.equals(CURLY_BRACKETS)) {
                return CURLY_BRACKETS;
            }
        }
        this.quote = String.valueOf(Character.toChars(this.quotes[1]));
        this.trimmedSeparator = CharSequences.trimWhitespaces(this.separator.trim());
        return this;
    }
}

