/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.util.Static;
import org.opengis.referencing.datum.Ellipsoid;

public final class Formulas
extends Static {
    public static final double LINEAR_TOLERANCE = 0.01;
    public static final double ANGULAR_TOLERANCE = 8.999280057595393E-8;
    public static final double TEMPORAL_TOLERANCE = 60.0;
    public static final double LONGITUDE_MAX = 4.052915431398935E8;
    public static final long JULIAN_YEAR_LENGTH = 31557600000L;
    public static final int MAXIMUM_ITERATIONS = 18;

    private Formulas() {
    }

    public static boolean isPoleToPole(double d, double d2) {
        return Math.abs(d - -90.0) <= 8.999280057595393E-8 && Math.abs(d2 - 90.0) <= 8.999280057595393E-8;
    }

    public static double scaleComparedToEarth(Ellipsoid ellipsoid) {
        return Formulas.getAuthalicRadius(ellipsoid) / 6371007.180918474;
    }

    public static double getAuthalicRadius(Ellipsoid ellipsoid) {
        if (ellipsoid == null) {
            return Double.NaN;
        }
        if (ellipsoid instanceof DefaultEllipsoid) {
            return ((DefaultEllipsoid)ellipsoid).getAuthalicRadius();
        }
        return Formulas.getAuthalicRadius(ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis());
    }

    public static double getAuthalicRadius(double d, double d2) {
        if (d != d2) {
            double d3 = 1.0 - d2 / d;
            double d4 = Math.sqrt(2.0 * d3 - d3 * d3);
            return Math.sqrt(0.5 * (d * d + d2 * d2 * MathFunctions.atanh(d4) / d4));
        }
        return d;
    }

    public static double getSemiMinor(double d, double d2) {
        return d * (1.0 - 1.0 / d2);
    }

    public static double getInverseFlattening(double d, double d2) {
        return d / (d - d2);
    }
}

