/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.Predicate;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.console.OutputFormat;
import org.apache.sis.internal.storage.CodeType;
import org.apache.sis.internal.storage.gpx.Store;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.referencing.CRS;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.MarshallerPool;
import org.opengis.metadata.Metadata;
import org.opengis.util.FactoryException;

abstract class FormattedOutputCommand
extends CommandRunner {
    private final OutputFormat outputFormat;
    Convention convention;
    private Version version;
    private final DataStoreProvider provider;
    boolean hasUnexpectedFileCount;

    FormattedOutputCommand(int n, String[] stringArray, EnumSet<Option> enumSet, OutputFormat ... outputFormatArray) throws InvalidOptionException {
        super(n, stringArray, enumSet);
        boolean bl = true;
        String string = (String)this.options.get((Object)Option.FORMAT);
        if (string == null) {
            this.outputFormat = outputFormatArray[0];
            this.convention = Convention.WKT2_SIMPLIFIED;
        } else if (string.equalsIgnoreCase("WKT1")) {
            this.outputFormat = OutputFormat.WKT;
            this.convention = Convention.WKT1;
        } else if (string.equalsIgnoreCase("WKT2")) {
            this.outputFormat = OutputFormat.WKT;
            this.convention = Convention.WKT2;
        } else {
            int n2 = string.indexOf(45);
            String string2 = string;
            if (n2 > 0) {
                string2 = string.substring(0, n2);
                this.version = new Version(string.substring(n2 + 1).trim());
            }
            string2 = string2.toUpperCase(Locale.US);
            try {
                this.outputFormat = OutputFormat.valueOf(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidOptionException(Errors.format((short)56, (Object)"format", (Object)string), illegalArgumentException, "format");
            }
        }
        if (!ArraysExt.contains((Object[])outputFormatArray, (Object)((Object)this.outputFormat))) {
            throw new InvalidOptionException(Errors.format((short)62, (Object)this.commandName, (Object)((Object)this.outputFormat)), "format");
        }
        this.provider = this.outputFormat.provider();
        switch (this.outputFormat) {
            case WKT: {
                if (this.convention != null) break;
                if (this.version == null || this.version.equals((Object)Version.valueOf((int[])new int[]{2}))) {
                    this.convention = Convention.WKT2;
                    break;
                }
                this.convention = Convention.WKT1;
                bl = this.version.equals((Object)Version.valueOf((int[])new int[]{1}));
                break;
            }
            default: {
                if (this.version == null || !(bl = this.provider != null)) break;
                Range range = this.provider.getSupportedVersions();
                boolean bl2 = bl = range != null && range.contains((Comparable)this.version);
            }
        }
        if (!bl) {
            throw new InvalidOptionException(Errors.format((short)159, (Object)this.outputFormat.name(), (Object)this.version), "format");
        }
    }

    final Object readMetadataOrCRS() throws DataStoreException, FactoryException {
        if (this.useStandardInput()) {
            try (DataStore dataStore = DataStores.open((Object)System.in);){
                Metadata metadata = dataStore.getMetadata();
                return metadata;
            }
        }
        if (this.hasUnexpectedFileCount(1, 1)) {
            this.hasUnexpectedFileCount = true;
            return null;
        }
        String string = (String)this.files.get(0);
        if (CodeType.guess((String)string).isCRS) {
            return CRS.forCode((String)string);
        }
        try (DataStore dataStore = DataStores.open((Object)string);){
            Metadata metadata = dataStore.getMetadata();
            return metadata;
        }
    }

    final void format(Object object) throws DataStoreException, JAXBException, IOException {
        switch (this.outputFormat) {
            case TEXT: {
                TreeTable treeTable = MetadataStandard.ISO_19115.asTreeTable(object, object instanceof Metadata ? Metadata.class : null, ValueExistencePolicy.COMPACT);
                TreeTableFormat treeTableFormat = new TreeTableFormat(this.locale, this.timezone);
                treeTableFormat.setColumns(new TableColumn[]{TableColumn.NAME, TableColumn.VALUE});
                treeTableFormat.setNodeFilter(this.getNodeFilter());
                treeTableFormat.format(treeTable, (Appendable)this.out);
                break;
            }
            case WKT: {
                WKTFormat wKTFormat = new WKTFormat(this.locale, this.timezone);
                if (this.convention != null) {
                    wKTFormat.setConvention(this.convention);
                }
                if (this.colors) {
                    wKTFormat.setColors(Colors.DEFAULT);
                }
                wKTFormat.format(object, (Appendable)this.out);
                this.out.println();
                break;
            }
            case XML: {
                MarshallerPool marshallerPool = new MarshallerPool(null);
                Marshaller marshaller = marshallerPool.acquireMarshaller();
                marshaller.setProperty("org.apache.sis.xml.locale", (Object)this.locale);
                marshaller.setProperty("org.apache.sis.xml.timezone", (Object)this.timezone);
                if (this.isConsole()) {
                    marshaller.marshal(object, (Writer)this.out);
                    break;
                }
                this.out.flush();
                marshaller.setProperty("jaxb.encoding", (Object)this.encoding.name());
                marshaller.marshal(object, (OutputStream)System.out);
                System.out.flush();
                break;
            }
            default: {
                StorageConnector storageConnector = new StorageConnector((Object)this.out);
                storageConnector.setOption(OptionKey.TIMEZONE, (Object)this.timezone);
                storageConnector.setOption(OptionKey.LOCALE, (Object)this.locale);
                storageConnector.setOption(OptionKey.ENCODING, (Object)this.encoding);
                try (DataStore dataStore = this.provider.open(storageConnector);){
                    Store store = (Store)dataStore;
                    if (this.version != null) {
                        store.setVersion(this.version);
                    }
                    store.write(object instanceof Metadata ? (Metadata)object : null, null);
                    break;
                }
            }
        }
        this.out.flush();
    }

    Predicate<TreeTable.Node> getNodeFilter() {
        return null;
    }

    private boolean isConsole() {
        if (this.outputBuffer != null) {
            return true;
        }
        Console console = System.console();
        return console != null && console.writer() == this.out;
    }
}

