/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.spatial.GCP;

@XmlType(name="MI_GCP_Type", propOrder={"accuracyReports"})
@XmlRootElement(name="MI_GCP")
public class DefaultGCP
extends ISOMetadata
implements GCP {
    private static final long serialVersionUID = -2021981491910341192L;
    private DirectPosition geographicCoordinates;
    private Collection<Element> accuracyReports;

    public DefaultGCP() {
    }

    public DefaultGCP(GCP gCP) {
        super(gCP);
        if (gCP != null) {
            this.accuracyReports = this.copyCollection(gCP.getAccuracyReports(), Element.class);
            this.geographicCoordinates = gCP.getGeographicCoordinates();
        }
    }

    public static DefaultGCP castOrCopy(GCP gCP) {
        if (gCP == null || gCP instanceof DefaultGCP) {
            return (DefaultGCP)gCP;
        }
        return new DefaultGCP(gCP);
    }

    @Override
    public DirectPosition getGeographicCoordinates() {
        return this.geographicCoordinates;
    }

    public void setGeographicCoordinates(DirectPosition directPosition) {
        this.checkWritePermission(this.geographicCoordinates);
        this.geographicCoordinates = directPosition;
    }

    @XmlElement(name="accuracyReport")
    public Collection<Element> getAccuracyReports() {
        this.accuracyReports = this.nonNullCollection(this.accuracyReports, Element.class);
        return this.accuracyReports;
    }

    public void setAccuracyReports(Collection<? extends Element> collection) {
        this.accuracyReports = this.writeCollection(collection, this.accuracyReports, Element.class);
    }
}

