/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.ucar.CSBuilderFallback;
import org.apache.sis.internal.netcdf.ucar.FeaturesWrapper;
import org.apache.sis.internal.netcdf.ucar.GridWrapper;
import org.apache.sis.internal.netcdf.ucar.GroupWrapper;
import org.apache.sis.internal.netcdf.ucar.LogAdapter;
import org.apache.sis.internal.netcdf.ucar.Utils;
import org.apache.sis.internal.netcdf.ucar.VariableWrapper;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;

public final class DecoderWrapper
extends Decoder
implements CancelTask {
    private final NetcdfFile file;
    private Group[] groups;
    private transient VariableWrapper[] variables;
    private transient FeatureDataset features;
    private transient Grid[] geometries;

    public DecoderWrapper(NetcdfFile netcdfFile, GeometryLibrary geometryLibrary, StoreListeners storeListeners) {
        super(geometryLibrary, storeListeners);
        this.file = netcdfFile;
        this.groups = new Group[1];
        this.initialize();
    }

    public DecoderWrapper(String string, GeometryLibrary geometryLibrary, StoreListeners storeListeners) throws IOException {
        super(geometryLibrary, storeListeners);
        NetcdfDataset netcdfDataset = NetcdfDataset.openDataset((String)string, (boolean)false, (CancelTask)this);
        netcdfDataset.enhance(Collections.singleton(NetcdfDataset.Enhance.CoordSystems));
        this.file = netcdfDataset;
        this.groups = new Group[1];
        this.initialize();
    }

    @Override
    public String getFilename() {
        String string = Utils.nonEmpty(this.file.getLocation());
        if (string != null) {
            int n = string.lastIndexOf(File.separatorChar);
            if (n < 0 && File.separatorChar != '/') {
                n = string.lastIndexOf(47);
            }
            if (n >= 0) {
                string = string.substring(n + 1);
            }
        }
        return string;
    }

    @Override
    public String[] getFormatDescription() {
        String string = Utils.nonEmpty(this.file.getFileTypeVersion());
        String[] stringArray = new String[string != null ? 3 : 2];
        switch (stringArray.length) {
            default: {
                stringArray[2] = string;
            }
            case 2: {
                stringArray[1] = this.file.getFileTypeDescription();
            }
            case 1: {
                stringArray[0] = this.file.getFileTypeId();
            }
            case 0: 
        }
        return stringArray;
    }

    @Override
    public void setSearchPath(String ... stringArray) {
        Group[] groupArray = new Group[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            if (string != null) {
                Group group = this.file.findGroup(string);
                if (group == null) continue;
                groupArray[n] = group;
            }
            ++n;
        }
        this.groups = ArraysExt.resize(groupArray, n);
    }

    @Override
    public String[] getSearchPath() {
        String[] stringArray = new String[this.groups.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Group group = this.groups[i];
            if (group == null) continue;
            stringArray[i] = group.getShortName();
        }
        return stringArray;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames(this.file.getGlobalAttributes());
    }

    private Attribute findAttribute(Group group, String string) {
        String string2;
        Attribute attribute;
        Attribute attribute2 = attribute = group != null ? group.findAttributeIgnoreCase(string) : this.file.findGlobalAttributeIgnoreCase(string);
        if (attribute == null && (string2 = this.convention().mapAttributeName(string)) != string) {
            attribute = group != null ? group.findAttributeIgnoreCase(string2) : this.file.findGlobalAttributeIgnoreCase(string2);
        }
        return attribute;
    }

    @Override
    public String stringValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null || !attribute.isString()) continue;
                return Utils.nonEmpty(attribute.getStringValue());
            }
        }
        return null;
    }

    @Override
    public Number numericValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null) continue;
                Number number = attribute.getNumericValue();
                if (number != null) {
                    return Utils.fixSign(number, attribute.isUnsigned());
                }
                String string2 = Utils.nonEmpty(attribute.getStringValue());
                if (string2 == null) continue;
                return this.parseNumber(string, string2);
            }
        }
        return null;
    }

    @Override
    public Date dateValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                CalendarDate calendarDate;
                String string2;
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null || !attribute.isString() || (string2 = Utils.nonEmpty(attribute.getStringValue())) == null) continue;
                try {
                    calendarDate = CalendarDateFormatter.isoStringToCalendarDate((Calendar)Calendar.proleptic_gregorian, (String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.listeners.warning(illegalArgumentException);
                    continue;
                }
                return new Date(calendarDate.getMillis());
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String string, Number ... numberArray) {
        DateUnit dateUnit;
        Date[] dateArray = new Date[numberArray.length];
        try {
            dateUnit = new DateUnit(string);
        }
        catch (Exception exception) {
            this.listeners.warning(exception);
            return dateArray;
        }
        for (int i = 0; i < numberArray.length; ++i) {
            Number number = numberArray[i];
            if (number == null) continue;
            dateArray[i] = dateUnit.makeDate(number.doubleValue());
        }
        return dateArray;
    }

    @Override
    public String getId() {
        return Utils.nonEmpty(this.file.getId());
    }

    @Override
    public String getTitle() {
        return Utils.nonEmpty(this.file.getTitle());
    }

    @Override
    public Variable[] getVariables() {
        if (this.variables == null) {
            List list = this.file.getVariables();
            this.variables = new VariableWrapper[list != null ? list.size() : 0];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = new VariableWrapper(this, (VariableIF)list.get(i));
            }
        }
        return this.variables;
    }

    final VariableWrapper getWrapperFor(VariableIF variableIF) {
        for (VariableWrapper variableWrapper : (VariableWrapper[])this.getVariables()) {
            if (!variableWrapper.isWrapperFor(variableIF)) continue;
            return variableWrapper;
        }
        return new VariableWrapper(this, variableIF);
    }

    @Override
    public DiscreteSampling[] getDiscreteSampling() throws IOException, DataStoreException {
        if (this.features == null && this.file instanceof NetcdfDataset) {
            this.features = FeatureDatasetFactoryManager.wrap(null, (NetcdfDataset)((NetcdfDataset)this.file), (CancelTask)this, (Formatter)new Formatter(new LogAdapter(this.listeners), this.listeners.getLocale()));
        }
        List list = null;
        if (this.features instanceof FeatureDatasetPoint) {
            list = ((FeatureDatasetPoint)this.features).getPointFeatureCollectionList();
        }
        DiscreteSampling[] discreteSamplingArray = new FeaturesWrapper[list != null ? list.size() : 0];
        try {
            for (int i = 0; i < discreteSamplingArray.length; ++i) {
                discreteSamplingArray[i] = new FeaturesWrapper((FeatureCollection)list.get(i), this.geomlib, this.listeners);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataStoreException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
        }
        return discreteSamplingArray;
    }

    @Override
    public Grid[] getGrids() throws IOException {
        if (this.geometries == null) {
            List list = null;
            if (this.file instanceof NetcdfDataset) {
                NetcdfDataset netcdfDataset = (NetcdfDataset)this.file;
                EnumSet<NetcdfDataset.Enhance> enumSet = EnumSet.copyOf(netcdfDataset.getEnhanceMode());
                if (enumSet.add(NetcdfDataset.Enhance.CoordSystems)) {
                    netcdfDataset.enhance(enumSet);
                }
                if ((list = netcdfDataset.getCoordinateSystems()).isEmpty() && this.convention() != Convention.DEFAULT) {
                    CSBuilderFallback cSBuilderFallback = new CSBuilderFallback(this);
                    cSBuilderFallback.buildCoordinateSystems(netcdfDataset);
                    list = netcdfDataset.getCoordinateSystems();
                }
            }
            this.geometries = new Grid[list != null ? list.size() : 0];
            for (int i = 0; i < this.geometries.length; ++i) {
                this.geometries[i] = new GridWrapper((CoordinateSystem)list.get(i));
            }
        }
        return this.geometries;
    }

    @Override
    protected Node findNode(String string) {
        ucar.nc2.Variable variable = this.file.findVariable(string);
        if (variable != null) {
            return this.getWrapperFor((VariableIF)variable);
        }
        Group group = this.file.findGroup(string);
        return group != null ? new GroupWrapper(this, group) : null;
    }

    public boolean isCancel() {
        return this.canceled;
    }

    public void setProgress(String string, int n) {
    }

    public void setError(String string) {
        this.listeners.warning(string);
    }

    @Override
    public void close() throws IOException {
        if (this.features != null) {
            this.features.close();
            this.features = null;
        }
        this.file.close();
    }

    public String toString() {
        return "UCAR driver: \u201c" + this.getFilename() + '\u201d';
    }
}

