/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.math.Vector;

public abstract class ByteWriter {
    private ByteWriter() {
    }

    public static ByteWriter create(Vector vector, byte[] byArray) {
        return ByteWriter.create(vector.buffer().orElseGet(() -> DoubleBuffer.wrap(vector.doubleValues())), ByteBuffer.wrap(byArray).order(ByteOrder.nativeOrder()));
    }

    public static ByteWriter create(Buffer buffer, ByteBuffer byteBuffer) {
        if (buffer.limit() != buffer.capacity()) {
            buffer = JDK9.slice(buffer);
        }
        if (buffer instanceof DoubleBuffer) {
            return new Doubles((DoubleBuffer)buffer, byteBuffer);
        }
        if (buffer instanceof FloatBuffer) {
            return new Floats((FloatBuffer)buffer, byteBuffer);
        }
        if (buffer instanceof LongBuffer) {
            return new Longs((LongBuffer)buffer, byteBuffer);
        }
        if (buffer instanceof IntBuffer) {
            return new Integers((IntBuffer)buffer, byteBuffer);
        }
        if (buffer instanceof ShortBuffer) {
            return new Shorts((ShortBuffer)buffer, byteBuffer);
        }
        if (buffer instanceof ByteBuffer) {
            return new Bytes((ByteBuffer)buffer, byteBuffer);
        }
        throw new IllegalArgumentException();
    }

    public abstract int write();

    private static void reset(Buffer buffer, Buffer buffer2) {
        buffer2.clear();
        buffer.limit(Math.min(buffer.capacity(), buffer.position() + buffer2.capacity()));
    }

    private static final class Bytes
    extends ByteWriter {
        private final ByteBuffer source;
        private final ByteBuffer target;

        Bytes(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            this.source = byteBuffer;
            this.target = byteBuffer2;
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 1;
        }
    }

    private static final class Shorts
    extends ByteWriter {
        private final ShortBuffer source;
        private final ShortBuffer target;

        Shorts(ShortBuffer shortBuffer, ByteBuffer byteBuffer) {
            this.source = shortBuffer;
            this.target = byteBuffer.asShortBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 2;
        }
    }

    private static final class Integers
    extends ByteWriter {
        private final IntBuffer source;
        private final IntBuffer target;

        Integers(IntBuffer intBuffer, ByteBuffer byteBuffer) {
            this.source = intBuffer;
            this.target = byteBuffer.asIntBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 4;
        }
    }

    private static final class Longs
    extends ByteWriter {
        private final LongBuffer source;
        private final LongBuffer target;

        Longs(LongBuffer longBuffer, ByteBuffer byteBuffer) {
            this.source = longBuffer;
            this.target = byteBuffer.asLongBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 8;
        }
    }

    private static final class Floats
    extends ByteWriter {
        private final FloatBuffer source;
        private final FloatBuffer target;

        Floats(FloatBuffer floatBuffer, ByteBuffer byteBuffer) {
            this.source = floatBuffer;
            this.target = byteBuffer.asFloatBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 4;
        }
    }

    private static final class Doubles
    extends ByteWriter {
        private final DoubleBuffer source;
        private final DoubleBuffer target;

        Doubles(DoubleBuffer doubleBuffer, ByteBuffer byteBuffer) {
            this.source = doubleBuffer;
            this.target = byteBuffer.asDoubleBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 8;
        }
    }
}

