/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import org.apache.sis.internal.simple.SimpleMetadata;
import org.apache.sis.internal.storage.gpx.Bounds;
import org.apache.sis.internal.storage.gpx.Copyright;
import org.apache.sis.internal.storage.gpx.Link;
import org.apache.sis.internal.storage.gpx.Person;
import org.apache.sis.internal.storage.gpx.Store;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.TableAppender;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultKeywords;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

public final class Metadata
extends SimpleMetadata {
    Store store;
    public String creator;
    @XmlElement(name="name")
    public String name;
    @XmlElement(name="desc")
    public String description;
    @XmlElement(name="author")
    public Person author;
    @XmlElement(name="copyright")
    public Copyright copyright;
    @XmlElement(name="link")
    public List<Link> links;
    @XmlElement(name="time")
    public Date time;
    @XmlList
    @XmlElement(name="keywords")
    public List<String> keywords;
    @XmlElement(name="bounds")
    public Bounds bounds;
    private Format format;

    public Metadata() {
    }

    Metadata(org.opengis.metadata.Metadata metadata, Locale locale) {
        block0: for (Identification identification : metadata.getIdentificationInfo()) {
            Citation citation = identification.getCitation();
            if (citation != null) {
                if (this.name == null) {
                    this.name = Types.toString((InternationalString)citation.getTitle(), (Locale)locale);
                }
                if (this.time == null) {
                    for (ResponsibleParty responsibleParty : citation.getDates()) {
                        this.time = responsibleParty.getDate();
                        if (this.time == null) continue;
                        break;
                    }
                }
                if (citation instanceof DefaultCitation) {
                    for (ResponsibleParty responsibleParty : ((DefaultCitation)citation).getOnlineResources()) {
                        this.links = Metadata.addIfNonNull(this.links, Link.castOrCopy((OnlineResource)responsibleParty, locale));
                    }
                }
            }
            if (this.description == null) {
                this.description = Types.toString((InternationalString)identification.getAbstract(), (Locale)locale);
            }
            for (ResponsibleParty responsibleParty : identification.getPointOfContacts()) {
                Person person = Person.castOrCopy(responsibleParty, locale);
                if (person == null) continue;
                if (person.isCreator) {
                    if (this.creator != null) continue;
                    this.creator = person.name;
                    continue;
                }
                if (this.author != null) continue;
                this.author = person;
            }
            if (this.copyright == null) {
                for (ResponsibleParty responsibleParty : identification.getResourceConstraints()) {
                    if (!(responsibleParty instanceof LegalConstraints)) continue;
                    this.copyright = Copyright.castOrCopy((LegalConstraints)responsibleParty, locale);
                    if (this.copyright == null) continue;
                    break;
                }
            }
            for (ResponsibleParty responsibleParty : identification.getDescriptiveKeywords()) {
                for (InternationalString internationalString : responsibleParty.getKeywords()) {
                    this.keywords = Metadata.addIfNonNull(this.keywords, Types.toString((InternationalString)internationalString, (Locale)locale));
                }
            }
            if (this.bounds != null || !(identification instanceof AbstractIdentification)) continue;
            for (ResponsibleParty responsibleParty : ((AbstractIdentification)identification).getExtents()) {
                this.bounds = Bounds.castOrCopy(Extents.getGeographicBoundingBox((Extent)responsibleParty));
                if (this.bounds == null) continue;
                continue block0;
            }
        }
    }

    public static Metadata castOrCopy(org.opengis.metadata.Metadata metadata, Locale locale) {
        return metadata == null || metadata instanceof Metadata ? (Metadata)metadata : new Metadata(metadata, locale);
    }

    public InternationalString getTitle() {
        return this.name != null ? new SimpleInternationalString(this.name) : super.getTitle();
    }

    public InternationalString getAbstract() {
        return this.description != null ? new SimpleInternationalString(this.description) : super.getAbstract();
    }

    public Collection<Keywords> getDescriptiveKeywords() {
        if (this.keywords != null) {
            return Collections.singletonList(new DefaultKeywords((CharSequence[])this.keywords.toArray(new String[this.keywords.size()])));
        }
        return Collections.emptyList();
    }

    public Collection<ResponsibleParty> getPointOfContacts() {
        if (this.creator != null) {
            Person person = new Person(this.creator);
            return this.author != null ? UnmodifiableArrayList.wrap(new ResponsibleParty[]{person, this.author}) : Collections.singletonList(this.author);
        }
        return this.author != null ? Collections.singletonList(this.author) : Collections.emptyList();
    }

    public Collection<Constraints> getResourceConstraints() {
        return this.copyright != null ? Collections.singletonList(this.copyright) : Collections.emptyList();
    }

    public Collection<Extent> getExtents() {
        return this.bounds != null ? Collections.singletonList(this.bounds) : Collections.emptyList();
    }

    public Collection<ReferenceSystem> getReferenceSystemInfo() {
        return Collections.singletonList(CommonCRS.WGS84.geographic());
    }

    public Collection<CitationDate> getDates() {
        if (this.time != null) {
            return Collections.singletonList(new DefaultCitationDate(this.time, DateType.CREATION));
        }
        return Collections.emptyList();
    }

    public Collection<ContentInformation> getContentInfo() {
        Store store = this.store;
        return store != null ? store.types.metadata : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Format> getResourceFormats() {
        Store store = this.store;
        if (store != null) {
            Format format;
            Store store2 = store;
            synchronized (store2) {
                format = this.format;
                if (format == null) {
                    this.format = format = store.getFormat();
                }
            }
            return Collections.singletonList(format);
        }
        return Collections.emptyList();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Metadata) {
            Metadata metadata = (Metadata)((Object)object);
            return Objects.equals(this.creator, metadata.creator) && Objects.equals(this.name, metadata.name) && Objects.equals(this.description, metadata.description) && Objects.equals(this.author, metadata.author) && Objects.equals(this.copyright, metadata.copyright) && Objects.equals(this.links, metadata.links) && Objects.equals(this.time, metadata.time) && Objects.equals(this.keywords, metadata.keywords) && Objects.equals((Object)this.bounds, (Object)metadata.bounds);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.creator, this.name, this.description, this.author, this.copyright, this.links, this.time, this.keywords, this.bounds});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GPX metadata").append(System.lineSeparator());
        TableAppender tableAppender = new TableAppender(stringBuilder);
        tableAppender.setMultiLinesCells(true);
        tableAppender.appendHorizontalSeparator();
        Metadata.append(tableAppender, "Creator", this.creator);
        Metadata.append(tableAppender, "Name", this.name);
        Metadata.append(tableAppender, "Description", this.description);
        Metadata.append(tableAppender, "Author", this.author);
        Metadata.append(tableAppender, "Copyright", this.copyright);
        Metadata.append(tableAppender, "Link(s)", this.links, System.lineSeparator());
        Metadata.append(tableAppender, "Time", this.time != null ? this.time.toInstant() : null);
        Metadata.append(tableAppender, "Keywords", this.keywords, " ");
        Metadata.append(tableAppender, "Bounds", (Object)this.bounds);
        tableAppender.appendHorizontalSeparator();
        try {
            tableAppender.flush();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuilder.toString();
    }

    private static void append(TableAppender tableAppender, String string, Object object) {
        if (object != null) {
            tableAppender.append(string).append(':').nextColumn();
            tableAppender.append(object.toString()).nextLine();
        }
    }

    private static void append(TableAppender tableAppender, String string, List<?> list, String string2) {
        if (list != null && !list.isEmpty()) {
            tableAppender.append(string).append(':').nextColumn();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    tableAppender.append(string2);
                }
                tableAppender.append(list.get(i).toString());
            }
            tableAppender.nextLine();
        }
    }

    static <T> List<T> addIfNonNull(List<T> list, T t) {
        if (t != null) {
            if (list == null) {
                list = new ArrayList<T>(4);
            }
            list.add(t);
        }
        return list;
    }
}

