/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.lang.reflect.Field;

final class GeoKeys {
    public static final short ModelType = 1024;
    public static final short RasterType = 1025;
    public static final short Citation = 1026;
    public static final short GeographicType = 2048;
    public static final short GeogCitation = 2049;
    public static final short GeodeticDatum = 2050;
    public static final short PrimeMeridian = 2051;
    public static final short GeogLinearUnits = 2052;
    public static final short GeogLinearUnitSize = 2053;
    public static final short AngularUnits = 2054;
    public static final short AngularUnitSize = 2055;
    public static final short Ellipsoid = 2056;
    public static final short SemiMajorAxis = 2057;
    public static final short SemiMinorAxis = 2058;
    public static final short InvFlattening = 2059;
    public static final short AzimuthUnits = 2060;
    public static final short PrimeMeridianLong = 2061;
    public static final short ProjectedCSType = 3072;
    public static final short PCSCitation = 3073;
    public static final short Projection = 3074;
    public static final short CoordTrans = 3075;
    public static final short LinearUnits = 3076;
    public static final short LinearUnitSize = 3077;
    public static final short StdParallel1 = 3078;
    public static final short StdParallel2 = 3079;
    public static final short NatOriginLong = 3080;
    public static final short NatOriginLat = 3081;
    public static final short FalseEasting = 3082;
    public static final short FalseNorthing = 3083;
    public static final short FalseOriginLong = 3084;
    public static final short FalseOriginLat = 3085;
    public static final short FalseOriginEasting = 3086;
    public static final short FalseOriginNorthing = 3087;
    public static final short CenterLong = 3088;
    public static final short CenterLat = 3089;
    public static final short CenterEasting = 3090;
    public static final short CenterNorthing = 3091;
    public static final short ScaleAtNatOrigin = 3092;
    public static final short ScaleAtCenter = 3093;
    public static final short AzimuthAngle = 3094;
    public static final short StraightVertPoleLong = 3095;
    public static final short RectifiedGridAngle = 3096;
    public static final short VerticalCSType = 4096;
    public static final short VerticalCitation = 4097;
    public static final short VerticalDatum = 4098;
    public static final short VerticalUnits = 4099;
    static final int RATIO = 0;
    static final int LINEAR = 1;
    static final int ANGULAR = 2;
    static final int AZIMUTH = 3;

    private GeoKeys() {
    }

    static int unitOf(short s) {
        if (s < 3078 || s > 3096) {
            return -1;
        }
        switch (s) {
            case 3082: 
            case 3083: 
            case 3086: 
            case 3087: 
            case 3090: 
            case 3091: {
                return 1;
            }
            case 3092: 
            case 3093: {
                return 0;
            }
            case 3094: 
            case 3096: {
                return 3;
            }
        }
        return 2;
    }

    static String name(short s) {
        try {
            for (Field field : GeoKeys.class.getFields()) {
                if (field.getType() != Short.TYPE || field.getShort(null) != s) continue;
                return field.getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        return Integer.toHexString(Short.toUnsignedInt(s));
    }
}

