/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sis.internal.jdk8;

import java.util.Objects;


/**
 * Placeholder for the {@link java.util.stream.StreamSupport} class.
 */
public final class StreamSupport {
    /**
     * Do not allow instantiation of this class.
     */
    private StreamSupport() {
    }

    /**
     * Wraps the given iterator in a stream.
     *
     * @param   <T>       type of values.
     * @param   it        the iterator to wrap.
     * @param   parallel  ignored.
     * @return  given iterator wrapped in a stream.
     */
    public static <T> Stream<T> stream(final Spliterator<T> it, boolean parallel) {
        Objects.requireNonNull(it);
        return new Stream<>(it);
    }
}
