/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.client.core.constant;

/**
 * ShenyuClientConstants.
 */
public final class ShenyuClientConstants {
    
    /**
     * the constant of APP_NAME.
     */
    public static final String APP_NAME = "appName";
    
    /**
     * the constant of CONTEXT_PATH.
     */
    public static final String CONTEXT_PATH = "contextPath";
    
    /**
     * the constant of IS_FULL.
     */
    public static final String IS_FULL = "isFull";
    
    /**
     * The constant HTTP.
     */
    public static final String HTTP = "http://";

    /**
     * The constant Websocket.
     */
    public static final String WS = "ws://";

    /**
     * The constant PROTOCOL.
     */
    public static final String PROTOCOL = "protocol";
    
    /**
     * the constant of HOST.
     */
    public static final String HOST = "host";
    
    /**
     * the constant of PORT.
     */
    public static final String PORT = "port";
    
    /**
     * the constant of IP_PORT.
     */
    public static final String IP_PORT = "ipAndPort";
    
    /**
     * the constant of SERVICE_NAME.
     */
    public static final String SERVICE_NAME = "SERVICE_NAME";

    /**
     * prefix forward status.
     */
    public static final String ADD_PREFIXED = "addPrefixed";

    /**
     * media type all value.
     */
    public static final String MEDIA_TYPE_ALL_VALUE = "*/*";
}
