/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.config.DataCenterProperties;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.registry.discovery.AbstractGroupDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;
import org.springframework.beans.factory.annotation.Autowired;

public class ZoneAwareDiscoveryFilter
extends AbstractGroupDiscoveryFilter {
    public static final String PARAMETER = "zone_aware_level";
    public static final String GROUP_PREFIX = "zone_aware_group_";
    public static final String GROUP_SIZE = "zone_aware_group_size";
    public static final String CONFIG_ENABLED = "servicecomb.loadbalance.filter.zoneaware.enabled";
    public static final String CONFIG_RATIO = "servicecomb.loadbalance.filter.zoneaware.ratio";
    public static final String CONFIG_RATIO_CEILING = "servicecomb.loadbalance.filter.zoneaware.ratioCeiling";
    private DataCenterProperties dataCenterProperties;

    @Autowired
    public void setDataCenterProperties(DataCenterProperties dataCenterProperties) {
        this.dataCenterProperties = dataCenterProperties;
    }

    public int getOrder() {
        return -9000;
    }

    public boolean enabled() {
        return (Boolean)this.environment.getProperty(CONFIG_ENABLED, Boolean.class, (Object)true);
    }

    private int getRatio() {
        return (Integer)this.environment.getProperty(CONFIG_RATIO, Integer.TYPE, (Object)30);
    }

    private int getRatioCeiling(int defaultValue) {
        return (Integer)this.environment.getProperty(CONFIG_RATIO_CEILING, Integer.TYPE, (Object)defaultValue);
    }

    protected String contextParameter() {
        return PARAMETER;
    }

    protected String groupsSizeParameter() {
        return GROUP_SIZE;
    }

    protected String groupPrefix() {
        return GROUP_PREFIX;
    }

    public void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        List instances = (List)parent.data();
        ArrayList<StatefulDiscoveryInstance> instancesRegionAndAZMatch = new ArrayList<StatefulDiscoveryInstance>();
        ArrayList<StatefulDiscoveryInstance> instancesAZMatch = new ArrayList<StatefulDiscoveryInstance>();
        ArrayList<StatefulDiscoveryInstance> instancesNoMatch = new ArrayList<StatefulDiscoveryInstance>();
        int groups = 1;
        for (StatefulDiscoveryInstance server : instances) {
            if (this.regionAndAZMatch(server)) {
                instancesRegionAndAZMatch.add(server);
                continue;
            }
            if (this.regionMatch(server)) {
                instancesAZMatch.add(server);
                continue;
            }
            instancesNoMatch.add(server);
        }
        int ratio = this.getRatio();
        int ratioCeiling = this.getRatioCeiling(100 - ratio);
        if (this.hasEnoughMembers(instances.size(), instancesRegionAndAZMatch.size(), ratio, ratioCeiling)) {
            parent.child(GROUP_PREFIX + groups, (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_PREFIX + groups).data(instancesRegionAndAZMatch));
            ++groups;
        } else {
            instancesAZMatch.addAll(instancesRegionAndAZMatch);
        }
        if (this.hasEnoughMembers(instances.size(), instancesAZMatch.size(), ratio, ratioCeiling)) {
            parent.child(GROUP_PREFIX + groups, (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_PREFIX + groups).data(instancesAZMatch));
            ++groups;
        } else {
            instancesNoMatch.addAll(instancesAZMatch);
        }
        parent.child(GROUP_PREFIX + groups, (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_PREFIX + groups).data(instancesNoMatch));
        parent.attribute(GROUP_SIZE, (Object)groups);
    }

    private boolean hasEnoughMembers(int totalSize, int groupSize, int ratio, int ratioCeiling) {
        if (totalSize == 0 || groupSize == 0) {
            return false;
        }
        int actual = Math.floorDiv(groupSize * 100, totalSize);
        return actual >= ratio && actual <= ratioCeiling;
    }

    private boolean regionAndAZMatch(StatefulDiscoveryInstance target) {
        if (this.dataCenterProperties.getRegion() != null && this.dataCenterProperties.getAvailableZone() != null && target.getDataCenterInfo() != null) {
            return this.dataCenterProperties.getRegion().equals(target.getDataCenterInfo().getRegion()) && this.dataCenterProperties.getAvailableZone().equals(target.getDataCenterInfo().getAvailableZone());
        }
        return false;
    }

    private boolean regionMatch(StatefulDiscoveryInstance target) {
        if (this.dataCenterProperties.getRegion() != null && target.getDataCenterInfo() != null) {
            return this.dataCenterProperties.getRegion().equals(target.getDataCenterInfo().getRegion());
        }
        return false;
    }
}

