/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.localregistry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.DataCenterProperties;
import org.apache.servicecomb.core.provider.LocalOpenAPIRegistry;
import org.apache.servicecomb.registry.RegistrationId;
import org.apache.servicecomb.registry.api.DataCenterInfo;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.RegistrationInstance;
import org.springframework.core.env.Environment;

public class LocalRegistrationInstance
implements RegistrationInstance {
    private final Environment environment;
    private final DataCenterInfo dataCenterInfo;
    private final LocalOpenAPIRegistry localOpenAPIRegistry;
    private final String instanceId;
    private final Map<String, String> schemas = new HashMap<String, String>();
    private final List<String> endpoints = new ArrayList<String>();
    private final Map<String, String> properties = new HashMap<String, String>();

    public LocalRegistrationInstance(Environment environment, DataCenterProperties dataCenterProperties, LocalOpenAPIRegistry localOpenAPIRegistry, RegistrationId registrationId) {
        this.environment = environment;
        this.localOpenAPIRegistry = localOpenAPIRegistry;
        this.dataCenterInfo = new DataCenterInfo();
        this.dataCenterInfo.setName(dataCenterProperties.getName());
        this.dataCenterInfo.setRegion(dataCenterProperties.getRegion());
        this.dataCenterInfo.setAvailableZone(dataCenterProperties.getAvailableZone());
        this.properties.putAll(BootStrapProperties.readServiceProperties((Environment)environment));
        this.instanceId = registrationId.getInstanceId();
    }

    public String getEnvironment() {
        return BootStrapProperties.readServiceEnvironment((Environment)this.environment);
    }

    public String getApplication() {
        return BootStrapProperties.readApplication((Environment)this.environment);
    }

    public String getServiceName() {
        return BootStrapProperties.readServiceName((Environment)this.environment);
    }

    public String getAlias() {
        return BootStrapProperties.readServiceAlias((Environment)this.environment);
    }

    public String getVersion() {
        return BootStrapProperties.readServiceVersion((Environment)this.environment);
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public String getDescription() {
        return BootStrapProperties.readServiceDescription((Environment)this.environment);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getSchemas() {
        return this.schemas;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public MicroserviceInstanceStatus getInitialStatus() {
        return MicroserviceInstanceStatus.STARTING;
    }

    public MicroserviceInstanceStatus getReadyStatus() {
        return MicroserviceInstanceStatus.UP;
    }

    public void addEndpoint(String endpoint) {
        this.endpoints.add(endpoint);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }
}

