/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.http.client.task.AbstractTask;
import org.apache.servicecomb.http.client.task.Task;
import org.apache.servicecomb.service.center.client.RegistrationEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.model.CreateSchemaRequest;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.apache.servicecomb.service.center.client.model.RegisteredMicroserviceInstanceResponse;
import org.apache.servicecomb.service.center.client.model.RegisteredMicroserviceResponse;
import org.apache.servicecomb.service.center.client.model.SchemaInfo;
import org.apache.servicecomb.service.center.client.model.ServiceCenterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterRegistration
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterRegistration.class);
    public static final int MAX_INTERVAL = 600000;
    public static final int MIN_INTERVAL = 1000;
    private final ServiceCenterClient serviceCenterClient;
    private final EventBus eventBus;
    private Microservice microservice;
    private MicroserviceInstance microserviceInstance;
    private List<SchemaInfo> schemaInfos = new ArrayList<SchemaInfo>();
    private final ServiceCenterConfiguration serviceCenterConfiguration;
    private long heartBeatInterval = 15000L;
    private long heartBeatRequestTimeout = 5000L;

    public ServiceCenterRegistration(ServiceCenterClient serviceCenterClient, ServiceCenterConfiguration serviceCenterConfiguration, EventBus eventBus) {
        super("service-center-registration-task");
        this.serviceCenterClient = serviceCenterClient;
        this.serviceCenterConfiguration = serviceCenterConfiguration;
        this.eventBus = eventBus;
    }

    public ServiceCenterRegistration setMicroserviceInstance(MicroserviceInstance microserviceInstance) {
        this.microserviceInstance = microserviceInstance;
        return this;
    }

    public ServiceCenterRegistration setMicroservice(Microservice microservice) {
        this.microservice = microservice;
        return this;
    }

    public ServiceCenterRegistration setHeartBeatInterval(long interval) {
        if (interval > 600000L || interval < 1000L) {
            return this;
        }
        this.heartBeatInterval = interval;
        return this;
    }

    public ServiceCenterRegistration setHeartBeatRequestTimeout(long timeout) {
        if (timeout > 600000L || timeout < 1000L) {
            return this;
        }
        this.heartBeatRequestTimeout = timeout;
        return this;
    }

    public ServiceCenterRegistration setSchemaInfos(List<SchemaInfo> schemaInfos) {
        this.schemaInfos = schemaInfos;
        return this;
    }

    public ServiceCenterRegistration addSchemaInfo(SchemaInfo schemaInfo) {
        this.schemaInfos.add(schemaInfo);
        return this;
    }

    public List<SchemaInfo> getSchemaInfos() {
        return this.schemaInfos;
    }

    public void startRegistration() {
        this.startTask(new RegisterMicroserviceTask(0));
        this.schedulerCheckAddressAvailable("sc-addr-check", new CheckAddressTask(), this.heartBeatInterval);
    }

    private boolean isSwaggerDifferent(Microservice newMicroservice) {
        return !this.isListEquals(newMicroservice.getSchemas(), this.microservice.getSchemas());
    }

    private boolean isListEquals(List<String> one, List<String> two) {
        return one.size() == two.size() && one.containsAll(two) && two.containsAll(one);
    }

    class RegisterMicroserviceTask
    implements Task {
        int failedCount;

        RegisterMicroserviceTask(int failedCount) {
            this.failedCount = failedCount;
        }

        public void execute() {
            try {
                RegisteredMicroserviceResponse serviceResponse = ServiceCenterRegistration.this.serviceCenterClient.queryServiceId(ServiceCenterRegistration.this.microservice);
                if (serviceResponse == null) {
                    RegisteredMicroserviceResponse response = ServiceCenterRegistration.this.serviceCenterClient.registerMicroservice(ServiceCenterRegistration.this.microservice);
                    if (StringUtils.isEmpty((CharSequence)response.getServiceId())) {
                        LOGGER.error("register microservice failed, and will try again.");
                        ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.MicroserviceRegistrationEvent(false, ServiceCenterRegistration.this.microservice));
                        ServiceCenterRegistration.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterRegistration.this, this.failedCount + 1, (Task)new RegisterMicroserviceTask(this.failedCount + 1)));
                        return;
                    }
                    ServiceCenterRegistration.this.microservice.setServiceId(response.getServiceId());
                    ServiceCenterRegistration.this.microserviceInstance.setServiceId(response.getServiceId());
                    ServiceCenterRegistration.this.microserviceInstance.setMicroservice(ServiceCenterRegistration.this.microservice);
                    ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.MicroserviceRegistrationEvent(true, ServiceCenterRegistration.this.microservice));
                    ServiceCenterRegistration.this.startTask(new RegisterSchemaTask(0));
                } else {
                    Microservice newMicroservice = ServiceCenterRegistration.this.serviceCenterClient.getMicroserviceByServiceId(serviceResponse.getServiceId());
                    Map<String, String> propertiesTemp = ServiceCenterRegistration.this.microservice.getProperties();
                    ServiceCenterRegistration.this.microservice.setProperties(newMicroservice.getProperties());
                    ServiceCenterRegistration.this.microservice.getProperties().putAll(propertiesTemp);
                    if (ServiceCenterRegistration.this.serviceCenterClient.updateMicroserviceProperties(serviceResponse.getServiceId(), ServiceCenterRegistration.this.microservice.getProperties())) {
                        LOGGER.info("microservice is already registered. Update microservice properties successfully. properties=[{}]", ServiceCenterRegistration.this.microservice.getProperties());
                    } else {
                        LOGGER.error("microservice is already registered. Update microservice properties failed. properties=[{}]", ServiceCenterRegistration.this.microservice.getProperties());
                    }
                    ServiceCenterRegistration.this.microservice.setServiceId(serviceResponse.getServiceId());
                    ServiceCenterRegistration.this.microserviceInstance.setServiceId(serviceResponse.getServiceId());
                    ServiceCenterRegistration.this.microserviceInstance.setMicroservice(ServiceCenterRegistration.this.microservice);
                    if (ServiceCenterRegistration.this.isSwaggerDifferent(newMicroservice)) {
                        if (ServiceCenterRegistration.this.serviceCenterConfiguration.isCanOverwriteSwagger()) {
                            LOGGER.warn("Service has already registered, but schema ids not equal, try to register it again");
                            ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.MicroserviceRegistrationEvent(true, ServiceCenterRegistration.this.microservice));
                            ServiceCenterRegistration.this.startTask(new RegisterSchemaTask(0));
                            return;
                        }
                        if (ServiceCenterRegistration.this.serviceCenterConfiguration.isIgnoreSwaggerDifferent()) {
                            LOGGER.warn("Service has already registered, but schema ids not equal. Ignore and continue to register");
                        } else {
                            throw new IllegalStateException("Service has already registered, but schema ids not equal, stop register. Change the microservice version or delete the old microservice info and try again.");
                        }
                    }
                    ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.MicroserviceRegistrationEvent(true, ServiceCenterRegistration.this.microservice));
                    ServiceCenterRegistration.this.startTask(new RegisterMicroserviceInstanceTask(0));
                }
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("register microservice failed, and will try again.", (Throwable)e);
                ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.MicroserviceRegistrationEvent(false, ServiceCenterRegistration.this.microservice));
                ServiceCenterRegistration.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterRegistration.this, this.failedCount + 1, (Task)new RegisterMicroserviceTask(this.failedCount + 1)));
            }
        }
    }

    class CheckAddressTask
    implements Runnable {
        CheckAddressTask() {
        }

        @Override
        public void run() {
            ServiceCenterRegistration.this.serviceCenterClient.checkIsolationAddressAvailable();
        }
    }

    class SendHeartBeatTask
    implements Task {
        private static final int FAILED_RETRY = 3;
        int failedCount;

        SendHeartBeatTask(int failedCount) {
            this.failedCount = failedCount;
        }

        public void execute() {
            try {
                if (this.failedCount >= 3) {
                    ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.HeartBeatEvent(false, ServiceCenterRegistration.this.microservice, ServiceCenterRegistration.this.microserviceInstance));
                    ServiceCenterRegistration.this.startTask(new RegisterMicroserviceTask(0));
                    return;
                }
                if (!ServiceCenterRegistration.this.serviceCenterClient.sendHeartBeat(ServiceCenterRegistration.this.microservice.getServiceId(), ServiceCenterRegistration.this.microserviceInstance.getInstanceId())) {
                    LOGGER.error("send heart failed, and will try again.");
                    ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.HeartBeatEvent(false, ServiceCenterRegistration.this.microservice, ServiceCenterRegistration.this.microserviceInstance));
                    ServiceCenterRegistration.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterRegistration.this, this.failedCount + 1, (Task)new SendHeartBeatTask(this.failedCount + 1)));
                } else {
                    ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.HeartBeatEvent(true, ServiceCenterRegistration.this.microservice, ServiceCenterRegistration.this.microserviceInstance));
                    ServiceCenterRegistration.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterRegistration.this, Math.max(ServiceCenterRegistration.this.heartBeatInterval, ServiceCenterRegistration.this.heartBeatRequestTimeout), (Task)new SendHeartBeatTask(0)));
                }
            }
            catch (Exception e) {
                LOGGER.error("send heart failed, and will try again.", (Throwable)e);
                ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.HeartBeatEvent(false, ServiceCenterRegistration.this.microservice, ServiceCenterRegistration.this.microserviceInstance));
                ServiceCenterRegistration.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterRegistration.this, this.failedCount + 1, (Task)new SendHeartBeatTask(this.failedCount + 1)));
            }
        }
    }

    class RegisterMicroserviceInstanceTask
    implements Task {
        int failedCount;

        RegisterMicroserviceInstanceTask(int failedCount) {
            this.failedCount = failedCount;
        }

        public void execute() {
            try {
                RegisteredMicroserviceInstanceResponse instance = ServiceCenterRegistration.this.serviceCenterClient.registerMicroserviceInstance(ServiceCenterRegistration.this.microserviceInstance);
                if (instance == null) {
                    LOGGER.error("register microservice instance failed, and will try again.");
                    ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.MicroserviceInstanceRegistrationEvent(false, ServiceCenterRegistration.this.microservice, ServiceCenterRegistration.this.microserviceInstance));
                    ServiceCenterRegistration.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterRegistration.this, this.failedCount + 1, (Task)new RegisterMicroserviceInstanceTask(this.failedCount + 1)));
                } else {
                    ServiceCenterRegistration.this.microserviceInstance.setInstanceId(instance.getInstanceId());
                    LOGGER.info("register microservice successfully, service id={}, instance id={}", (Object)ServiceCenterRegistration.this.microservice.getServiceId(), (Object)ServiceCenterRegistration.this.microserviceInstance.getInstanceId());
                    ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.MicroserviceInstanceRegistrationEvent(true, ServiceCenterRegistration.this.microservice, ServiceCenterRegistration.this.microserviceInstance));
                    ServiceCenterRegistration.this.startTask(new SendHeartBeatTask(0));
                }
            }
            catch (Exception e) {
                LOGGER.error("register microservice instance failed, and will try again.", (Throwable)e);
                ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.MicroserviceInstanceRegistrationEvent(false, ServiceCenterRegistration.this.microservice, ServiceCenterRegistration.this.microserviceInstance));
                ServiceCenterRegistration.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterRegistration.this, this.failedCount + 1, (Task)new RegisterMicroserviceInstanceTask(this.failedCount + 1)));
            }
        }
    }

    class RegisterSchemaTask
    implements Task {
        int failedCount;

        RegisterSchemaTask(int failedCount) {
            this.failedCount = failedCount;
        }

        public void execute() {
            try {
                if (ServiceCenterRegistration.this.schemaInfos == null || ServiceCenterRegistration.this.schemaInfos.isEmpty()) {
                    LOGGER.warn("no schemas defined for this microservice.");
                    ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.SchemaRegistrationEvent(true, ServiceCenterRegistration.this.microservice));
                    ServiceCenterRegistration.this.startTask(new RegisterMicroserviceInstanceTask(0));
                    return;
                }
                for (SchemaInfo schemaInfo : ServiceCenterRegistration.this.schemaInfos) {
                    CreateSchemaRequest request = new CreateSchemaRequest();
                    request.setSchema(schemaInfo.getSchema());
                    request.setSummary(schemaInfo.getSummary());
                    if (ServiceCenterRegistration.this.serviceCenterClient.registerSchema(ServiceCenterRegistration.this.microservice.getServiceId(), schemaInfo.getSchemaId(), request)) continue;
                    LOGGER.error("register schema content failed, and will try again.");
                    ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.SchemaRegistrationEvent(false, ServiceCenterRegistration.this.microservice));
                    ServiceCenterRegistration.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterRegistration.this, this.failedCount + 1, (Task)new RegisterSchemaTask((this.failedCount + 1) * 2)));
                    return;
                }
                ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.SchemaRegistrationEvent(true, ServiceCenterRegistration.this.microservice));
                ServiceCenterRegistration.this.startTask(new RegisterMicroserviceInstanceTask(0));
            }
            catch (Exception e) {
                LOGGER.error("register schema content failed, and will try again.", (Throwable)e);
                ServiceCenterRegistration.this.eventBus.post((Object)new RegistrationEvents.SchemaRegistrationEvent(false, ServiceCenterRegistration.this.microservice));
                ServiceCenterRegistration.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterRegistration.this, this.failedCount + 1, (Task)new RegisterSchemaTask((this.failedCount + 1) * 2)));
            }
        }
    }
}

