/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import com.google.common.annotations.VisibleForTesting;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.Set;
import org.apache.servicecomb.common.accessLog.AccessLogConfig;
import org.apache.servicecomb.common.accessLog.core.element.impl.LocalHostAccessItem;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.ExceptionUtils;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.foundation.ssl.SSLOptionFactory;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultHttpServerMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultServerEndpointMetric;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.vertx.GlobalRestFailureHandler;
import org.apache.servicecomb.transport.rest.vertx.HttpServerExceptionHandler;
import org.apache.servicecomb.transport.rest.vertx.TransportConfig;
import org.apache.servicecomb.transport.rest.vertx.VertxHttpDispatcher;
import org.apache.servicecomb.transport.rest.vertx.WebSocketDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class RestServerVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServerVerticle.class);
    private static final String SSL_KEY = "rest.provider";
    private URIEndpointObject endpointObject;
    private WebSocketDispatcher webSocketDispatcher;

    public void init(Vertx vertx, Context context) {
        super.init(vertx, context);
        Endpoint endpoint = (Endpoint)context.config().getValue("servicecomb.endpoint");
        this.endpointObject = (URIEndpointObject)endpoint.getAddress();
        this.webSocketDispatcher = new WebSocketDispatcher(endpoint);
    }

    public void start(Promise<Void> startPromise) throws Exception {
        try {
            super.start();
            if (this.endpointObject == null) {
                LOGGER.warn("rest listen address is not configured, will not start.");
                startPromise.complete();
                return;
            }
            Router mainRouter = Router.router((Vertx)this.vertx);
            this.mountAccessLogHandler(mainRouter);
            this.mountCorsHandler(mainRouter);
            this.initDispatcher(mainRouter);
            this.mountGlobalRestFailureHandler(mainRouter);
            HttpServer httpServer = this.createHttpServer();
            httpServer.requestHandler(httpServerRequest -> {
                if (this.endpointObject.isWebsocketEnabled()) {
                    String path = LegacyPropertyFactory.getStringProperty((String)"servicecomb.rest.server.websocket-prefix");
                    if (httpServerRequest.path().startsWith(path)) {
                        httpServerRequest.toWebSocket().onComplete(w -> this.webSocketDispatcher.onRequest((ServerWebSocket)w), e -> LOGGER.error("WebSocket error.", e));
                        return;
                    }
                }
                mainRouter.handle(httpServerRequest);
            });
            httpServer.connectionHandler(connection -> {
                int connectionLimit;
                DefaultHttpServerMetrics serverMetrics = (DefaultHttpServerMetrics)((ConnectionBase)connection).metrics();
                DefaultServerEndpointMetric endpointMetric = serverMetrics.getEndpointMetric();
                long connectedCount = endpointMetric.getCurrentConnectionCount();
                if (connectedCount > (long)(connectionLimit = LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.connection-limit", (int)Integer.MAX_VALUE))) {
                    connection.close();
                    endpointMetric.onRejectByConnectionLimit();
                }
            });
            List httpServerExceptionHandlers = SPIServiceUtils.getAllService(HttpServerExceptionHandler.class);
            httpServer.exceptionHandler(e -> {
                if (e instanceof ClosedChannelException) {
                    LOGGER.debug("Unexpected error in server.{}", (Object)ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)e));
                } else {
                    LOGGER.error("Unexpected error in server.{}", (Object)ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)e));
                }
                httpServerExceptionHandlers.forEach(httpServerExceptionHandler -> httpServerExceptionHandler.handle(e));
            });
            this.startListen(httpServer, startPromise);
        }
        catch (Throwable e2) {
            LOGGER.error("", e2);
            throw e2;
        }
    }

    @VisibleForTesting
    void mountGlobalRestFailureHandler(Router mainRouter) {
        GlobalRestFailureHandler globalRestFailureHandler = (GlobalRestFailureHandler)SPIServiceUtils.getPriorityHighestService(GlobalRestFailureHandler.class);
        Handler failureHandler = null == globalRestFailureHandler ? ctx -> {
            if (ctx.response().closed() || ctx.response().ended()) {
                LOGGER.error("get a failure with closed response", ctx.failure());
                return;
            }
            HttpServerResponse response = ctx.response();
            Throwable patt6922$temp = ctx.failure();
            if (patt6922$temp instanceof InvocationException) {
                InvocationException exception = (InvocationException)patt6922$temp;
                response.setStatusCode(exception.getStatusCode());
                response.setStatusMessage(exception.getReasonPhrase());
                response.end(exception.getErrorData().toString());
                return;
            }
            LOGGER.error("unexpected failure happened", ctx.failure());
            try {
                CommonExceptionData unknownError = new CommonExceptionData("unknown error");
                ctx.response().setStatusCode(500).putHeader("Content-Type", "application/json").end(RestObjectMapperFactory.getRestObjectMapper().writeValueAsString((Object)unknownError));
            }
            catch (Exception e) {
                LOGGER.error("failed to send error response!", (Throwable)e);
            }
        } : globalRestFailureHandler;
        mainRouter.route().handler(RoutingContext::next).failureHandler(failureHandler);
    }

    private void mountAccessLogHandler(Router mainRouter) {
        if (!AccessLogConfig.INSTANCE.isServerLogEnabled()) {
            return;
        }
        LOGGER.info("access log enabled, pattern = {}", (Object)AccessLogConfig.INSTANCE.getServerLogPattern());
        mainRouter.route().handler(context -> {
            ServerAccessLogEvent accessLogEvent = new ServerAccessLogEvent().setRoutingContext(context).setMilliStartTime(System.currentTimeMillis()).setLocalAddress(LocalHostAccessItem.getLocalAddress((RoutingContext)context));
            context.response().endHandler(event -> EventManager.post((Object)accessLogEvent.setMilliEndTime(System.currentTimeMillis())));
            context.next();
        });
    }

    void mountCorsHandler(Router mainRouter) {
        if (!TransportConfig.isCorsEnabled()) {
            return;
        }
        CorsHandler corsHandler = this.getCorsHandler();
        corsHandler.allowCredentials(TransportConfig.isCorsAllowCredentials());
        corsHandler.allowedHeaders(TransportConfig.getCorsAllowedHeaders());
        Set<String> allowedMethods = TransportConfig.getCorsAllowedMethods();
        for (String method : allowedMethods) {
            corsHandler.allowedMethod(HttpMethod.valueOf((String)method));
        }
        corsHandler.exposedHeaders(TransportConfig.getCorsExposedHeaders());
        int maxAge = TransportConfig.getCorsMaxAge();
        if (maxAge >= 0) {
            corsHandler.maxAgeSeconds(maxAge);
        }
        LOGGER.info("mount CorsHandler");
        mainRouter.route().handler((Handler)corsHandler);
    }

    private CorsHandler getCorsHandler() {
        CorsHandler handler = CorsHandler.create();
        String[] origin = TransportConfig.getCorsAllowedOrigin();
        if (origin == null) {
            handler.addOrigin("*");
        } else {
            for (String item : origin) {
                handler.addOrigin(item);
            }
        }
        return handler;
    }

    private void initDispatcher(Router mainRouter) {
        List dispatchers = SPIServiceUtils.getOrLoadSortedService(VertxHttpDispatcher.class);
        for (VertxHttpDispatcher dispatcher : dispatchers) {
            if (!dispatcher.enabled()) continue;
            dispatcher.init(mainRouter);
        }
    }

    private void startListen(HttpServer server, Promise<Void> startPromise) {
        server.listen(this.endpointObject.getPort(), this.endpointObject.getHostOrIp(), ar -> {
            if (ar.succeeded()) {
                LOGGER.info("rest listen success. address={}:{}", (Object)this.endpointObject.getHostOrIp(), (Object)((HttpServer)ar.result()).actualPort());
                startPromise.complete();
                return;
            }
            String msg = String.format("rest listen failed, address=%s:%d", this.endpointObject.getHostOrIp(), this.endpointObject.getPort());
            LOGGER.error(msg, ar.cause());
            startPromise.fail(ar.cause());
        });
    }

    private HttpServer createHttpServer() {
        HttpServerOptions serverOptions = this.createDefaultHttpServerOptions();
        return this.vertx.createHttpServer(serverOptions);
    }

    private HttpServerOptions createDefaultHttpServerOptions() {
        HttpServerOptions serverOptions = new HttpServerOptions();
        serverOptions.setCompressionSupported(TransportConfig.getCompressed());
        serverOptions.setMaxHeaderSize(TransportConfig.getMaxHeaderSize());
        serverOptions.setMaxFormAttributeSize(TransportConfig.getMaxFormAttributeSize());
        serverOptions.setMaxFormFields(TransportConfig.getMaxFormFields());
        serverOptions.setMaxFormBufferedBytes(TransportConfig.getMaxFormBufferedBytes());
        serverOptions.setCompressionLevel(TransportConfig.getCompressionLevel());
        serverOptions.setMaxChunkSize(TransportConfig.getMaxChunkSize());
        serverOptions.setDecompressionSupported(TransportConfig.getDecompressionSupported());
        serverOptions.setDecoderInitialBufferSize(TransportConfig.getDecoderInitialBufferSize());
        serverOptions.setMaxInitialLineLength(TransportConfig.getMaxInitialLineLength());
        if (this.endpointObject.isHttp2Enabled()) {
            serverOptions.setUseAlpn(TransportConfig.getUseAlpn()).setHttp2ConnectionWindowSize(TransportConfig.getHttp2ConnectionWindowSize()).setIdleTimeout(TransportConfig.getHttp2ConnectionIdleTimeoutInSeconds()).setHttp2RstFloodMaxRstFramePerWindow(TransportConfig.getHttp2RstFloodMaxRstFramePerWindow()).setInitialSettings(new Http2Settings().setPushEnabled(TransportConfig.getPushEnabled()).setMaxConcurrentStreams(TransportConfig.getMaxConcurrentStreams()).setHeaderTableSize(TransportConfig.getHttp2HeaderTableSize()).setInitialWindowSize(TransportConfig.getInitialWindowSize()).setMaxFrameSize(TransportConfig.getMaxFrameSize()).setMaxHeaderListSize((long)TransportConfig.getMaxHeaderListSize()));
        } else {
            serverOptions.setIdleTimeout(TransportConfig.getConnectionIdleTimeoutInSeconds());
        }
        if (this.endpointObject.isSslEnabled()) {
            SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)SSL_KEY, (Environment)LegacyPropertyFactory.getEnvironment());
            SSLOption sslOption = factory == null ? SSLOption.build((String)SSL_KEY, (Environment)LegacyPropertyFactory.getEnvironment()) : factory.createSSLOption();
            SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
            VertxTLSBuilder.buildNetServerOptions((SSLOption)sslOption, (SSLCustom)sslCustom, (NetServerOptions)serverOptions);
        }
        return serverOptions;
    }
}

