/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.LambdaUtils;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.apache.servicecomb.registry.api.LifeCycle;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.discovery.InstancePing;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DiscoveryManager
implements LifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryManager.class);
    private final ScheduledExecutorService task;
    private final List<Discovery<? extends DiscoveryInstance>> discoveryList;
    private final InstancePing ping;
    private final Map<String, Map<String, Map<String, StatefulDiscoveryInstance>>> allInstances = new ConcurrentHashMapEx();
    private final Map<String, Map<String, VersionedCache>> versionedCache = new ConcurrentHashMapEx();
    private final Object cacheLock = new Object();
    private final List<InstanceChangeListener> instanceChangeListeners = new ArrayList<InstanceChangeListener>();

    public DiscoveryManager(List<Discovery<? extends DiscoveryInstance>> discoveryList, List<InstancePing> pings) {
        this.discoveryList = discoveryList;
        for (Discovery<? extends DiscoveryInstance> discovery : this.discoveryList) {
            discovery.setInstanceChangedListener(this::onInstancesChanged);
        }
        this.ping = pings.get(0);
        this.task = Executors.newScheduledThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable, "discovery-manager-task"){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        LOGGER.error("discovery manager task error, not allowed please fix. ", e);
                    }
                }
            };
            thread.setPriority(1);
            thread.setDaemon(true);
            return thread;
        });
    }

    public Discovery<? extends DiscoveryInstance> getPrimaryDiscovery() {
        return this.discoveryList.get(0);
    }

    private void doTask() {
        try {
            this.doTaskImpl();
        }
        catch (Throwable e) {
            LOGGER.error("discovery manager task error. ", e);
        }
    }

    private void doTaskImpl() {
        HashMap<String, Map> removed = new HashMap<String, Map>();
        for (Map.Entry<String, Map<String, Map<String, StatefulDiscoveryInstance>>> entry : this.allInstances.entrySet()) {
            for (Map.Entry<String, Map<String, StatefulDiscoveryInstance>> services : entry.getValue().entrySet()) {
                boolean changed = false;
                for (StatefulDiscoveryInstance instance : services.getValue().values()) {
                    if (instance.getIsolationStatus() == StatefulDiscoveryInstance.IsolationStatus.ISOLATED && instance.getIsolatedTime() + instance.getIsolateDuration() < System.currentTimeMillis()) {
                        instance.setIsolationStatus(StatefulDiscoveryInstance.IsolationStatus.NORMAL);
                        changed = true;
                    }
                    if (System.currentTimeMillis() - instance.getPingTime() > 60000L) {
                        boolean pingResult = this.ping.ping(instance);
                        if (pingResult && instance.getPingStatus() != StatefulDiscoveryInstance.PingStatus.OK) {
                            instance.setPingStatus(StatefulDiscoveryInstance.PingStatus.OK);
                            changed = true;
                        } else if (!pingResult && instance.getPingStatus() != StatefulDiscoveryInstance.PingStatus.FAIL) {
                            instance.setPingStatus(StatefulDiscoveryInstance.PingStatus.FAIL);
                            changed = true;
                        }
                        instance.setPingTime(System.currentTimeMillis());
                    }
                    if (instance.getHistoryStatus() != StatefulDiscoveryInstance.HistoryStatus.HISTORY || instance.getStatus() == MicroserviceInstanceStatus.UP && instance.getPingStatus() != StatefulDiscoveryInstance.PingStatus.FAIL && instance.getIsolationStatus() != StatefulDiscoveryInstance.IsolationStatus.ISOLATED) continue;
                    removed.computeIfAbsent(entry.getKey(), k -> new HashMap()).computeIfAbsent(services.getKey(), k -> new ArrayList()).add(instance.getInstanceId());
                    LOGGER.info("Remove instance {}/{}/{}/{}/{}/{}/{}/{}", new Object[]{entry.getKey(), services.getKey(), instance.getRegistryName(), instance.getInstanceId(), instance.getHistoryStatus(), instance.getStatus(), instance.getPingStatus(), instance.getIsolationStatus()});
                    changed = true;
                }
                if (!changed) continue;
                this.rebuildVersionCache(entry.getKey(), services.getKey());
            }
        }
        for (Map.Entry<String, Map<String, Map<String, StatefulDiscoveryInstance>>> entry : removed.entrySet()) {
            for (Map.Entry<String, Map<String, StatefulDiscoveryInstance>> services : entry.getValue().entrySet()) {
                for (String instance : (List)((Object)services.getValue())) {
                    this.allInstances.get(entry.getKey()).get(services.getKey()).remove(instance);
                }
            }
        }
    }

    private void onInstancesChanged(String application, String serviceName, List<? extends DiscoveryInstance> instances) {
        this.onInstancesChanged(null, application, serviceName, instances);
    }

    private void onInstancesChanged(String registryName, String application, String serviceName, List<? extends DiscoveryInstance> instances) {
        for (InstanceChangeListener instanceChangeListener : this.instanceChangeListeners) {
            instanceChangeListener.onInstancesChanged(registryName, application, serviceName, instances);
        }
        Map statefulInstances = this.allInstances.computeIfAbsent(application, key -> new ConcurrentHashMapEx()).computeIfAbsent(serviceName, key -> new ConcurrentHashMapEx());
        for (StatefulDiscoveryInstance statefulDiscoveryInstance : statefulInstances.values()) {
            if (registryName != null && !registryName.equals(statefulDiscoveryInstance.getRegistryName()) || instances.contains(statefulDiscoveryInstance)) continue;
            statefulDiscoveryInstance.setPingTime(0L);
            statefulDiscoveryInstance.setHistoryStatus(StatefulDiscoveryInstance.HistoryStatus.HISTORY);
        }
        for (DiscoveryInstance discoveryInstance : instances) {
            StatefulDiscoveryInstance statefulDiscoveryInstance = new StatefulDiscoveryInstance(discoveryInstance);
            StatefulDiscoveryInstance origin = (StatefulDiscoveryInstance)statefulInstances.get(discoveryInstance.getInstanceId());
            if (origin == null) {
                statefulInstances.put(discoveryInstance.getInstanceId(), statefulDiscoveryInstance);
                continue;
            }
            statefulDiscoveryInstance.setPingTime(origin.getPingTime());
            statefulDiscoveryInstance.setPingStatus(origin.getPingStatus());
            statefulDiscoveryInstance.setIsolateDuration(origin.getIsolateDuration());
            statefulDiscoveryInstance.setIsolationStatus(origin.getIsolationStatus());
            statefulInstances.put(discoveryInstance.getInstanceId(), statefulDiscoveryInstance);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (DiscoveryInstance discoveryInstance : instances) {
            stringBuilder.append("{").append(discoveryInstance.getInstanceId()).append(",").append((Object)discoveryInstance.getStatus()).append(",").append(discoveryInstance.getEndpoints()).append(",").append(discoveryInstance.getRegistryName()).append("}");
        }
        LOGGER.info("Applying new instance list for {}/{}/{}. Endpoints {}", new Object[]{application, serviceName, instances.size(), stringBuilder});
        this.rebuildVersionCache(application, serviceName);
    }

    public void addInstanceChangeListener(InstanceChangeListener instanceChangeListener) {
        this.instanceChangeListeners.add(instanceChangeListener);
    }

    public void onInstanceIsolated(DiscoveryInstance instance, long isolateDuration) {
        Map statefulInstances = this.allInstances.computeIfAbsent(instance.getApplication(), key -> new ConcurrentHashMapEx()).computeIfAbsent(instance.getServiceName(), key -> new ConcurrentHashMapEx());
        StatefulDiscoveryInstance target = (StatefulDiscoveryInstance)statefulInstances.get(instance.getInstanceId());
        if (target == null) {
            return;
        }
        target.setIsolatedTime(System.currentTimeMillis());
        target.setIsolateDuration(isolateDuration);
        if (target.getIsolationStatus() != StatefulDiscoveryInstance.IsolationStatus.ISOLATED) {
            target.setIsolationStatus(StatefulDiscoveryInstance.IsolationStatus.ISOLATED);
            this.rebuildVersionCache(instance.getApplication(), instance.getServiceName());
        }
        LOGGER.warn("Isolated instance {}/{}/{}, time {}/{}", new Object[]{instance.getApplication(), instance.getServiceName(), instance.getInstanceId(), target.getIsolatedTime(), target.getIsolateDuration()});
    }

    private void rebuildVersionCache(String application, String serviceName) {
        Map caches = this.versionedCache.computeIfAbsent(application, key -> new ConcurrentHashMapEx());
        caches.put(serviceName, this.calcAvailableInstance(application, serviceName));
    }

    private VersionedCache calcAvailableInstance(String application, String serviceName) {
        Map statefulInstances = this.allInstances.computeIfAbsent(application, key -> new ConcurrentHashMapEx()).computeIfAbsent(serviceName, key -> new ConcurrentHashMapEx());
        ArrayList<StatefulDiscoveryInstance> result = new ArrayList<StatefulDiscoveryInstance>();
        for (StatefulDiscoveryInstance instance : statefulInstances.values()) {
            if (instance.getHistoryStatus() == StatefulDiscoveryInstance.HistoryStatus.CURRENT) {
                result.add(instance);
                continue;
            }
            if (instance.getHistoryStatus() != StatefulDiscoveryInstance.HistoryStatus.HISTORY || instance.getMicroserviceInstanceStatus() != MicroserviceInstanceStatus.UP || instance.getPingStatus() != StatefulDiscoveryInstance.PingStatus.OK || instance.getIsolationStatus() != StatefulDiscoveryInstance.IsolationStatus.NORMAL) continue;
            result.add(instance);
        }
        StringBuilder instanceInfo = new StringBuilder();
        for (StatefulDiscoveryInstance instance : result) {
            instanceInfo.append("{").append(instance.getInstanceId()).append(",").append((Object)instance.getHistoryStatus()).append(",").append((Object)instance.getStatus()).append(",").append((Object)instance.getPingStatus()).append(",").append((Object)instance.getIsolationStatus()).append(",").append(instance.getEndpoints()).append(",").append(instance.getRegistryName()).append("}");
        }
        LOGGER.info("Rebuild cached instance list for {}/{}/{}. Endpoints {}", new Object[]{application, serviceName, result.size(), instanceInfo});
        return new VersionedCache().name(application + ":" + serviceName).autoCacheVersion().data(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedCache getOrCreateVersionedCache(String application, String serviceName) {
        Map caches = this.versionedCache.computeIfAbsent(application, key -> new ConcurrentHashMapEx());
        VersionedCache cache = (VersionedCache)caches.get(serviceName);
        if (cache == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                cache = (VersionedCache)caches.get(serviceName);
                if (cache != null) {
                    return cache;
                }
                List<? extends DiscoveryInstance> instances = this.findServiceInstances(application, serviceName);
                this.onInstancesChanged(application, serviceName, instances);
                return this.versionedCache.get(application).get(serviceName);
            }
        }
        return cache;
    }

    public List<? extends DiscoveryInstance> findServiceInstances(String application, String serviceName) {
        ArrayList<? extends DiscoveryInstance> result = new ArrayList<DiscoveryInstance>();
        for (Discovery<? extends DiscoveryInstance> discovery : this.discoveryList) {
            List<? extends DiscoveryInstance> temp;
            if (!discovery.enabled() || !discovery.enabled(application, serviceName) || CollectionUtils.isEmpty(temp = discovery.findServiceInstances(application, serviceName))) continue;
            result.addAll(temp);
        }
        return result;
    }

    @Override
    public void destroy() {
        this.discoveryList.forEach(LambdaUtils.ignoreException(LifeCycle::destroy));
        this.task.shutdownNow();
    }

    @Override
    public void run() {
        this.discoveryList.forEach(LifeCycle::run);
        this.task.scheduleWithFixedDelay(this::doTask, 3L, 3L, TimeUnit.SECONDS);
    }

    @Override
    public void init() {
        this.discoveryList.forEach(LifeCycle::init);
    }

    public String info() {
        StringBuilder result = new StringBuilder();
        AtomicBoolean first = new AtomicBoolean(true);
        this.discoveryList.forEach(discovery -> {
            if (first.getAndSet(false)) {
                result.append("Discovery implementations:\n");
            }
            result.append("  name:").append(discovery.name()).append("\n");
        });
        return result.toString();
    }

    public static interface InstanceChangeListener {
        public void onInstancesChanged(String var1, String var2, String var3, List<? extends DiscoveryInstance> var4);
    }
}

